/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ldap;

import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class LDAPUtil {
    public static Object getAttributeObject(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeObject(attributes, id);
    }

    public static Object getAttributeObject(Attributes attributes, Properties properties, String key, Object defaultValue) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeObject(attributes, id, defaultValue);
    }

    public static Object getAttributeObject(Attributes attributes, String id) throws NamingException {
        return LDAPUtil.getAttributeObject(attributes, id, null);
    }

    public static Object getAttributeObject(Attributes attributes, String id, Object defaultValue) throws NamingException {
        if (Validator.isNull((String)id)) {
            return defaultValue;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return defaultValue;
        }
        Object object = attribute.get();
        if (object == null) {
            return defaultValue;
        }
        return object;
    }

    public static String getAttributeString(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeString(attributes, id);
    }

    public static String getAttributeString(Attributes attributes, Properties properties, String key, String defaultValue) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeString(attributes, id, defaultValue);
    }

    public static String getAttributeString(Attributes attributes, String id) throws NamingException {
        return LDAPUtil.getAttributeString(attributes, id, "");
    }

    public static String getAttributeString(Attributes attributes, String id, String defaultValue) throws NamingException {
        if (Validator.isNull((String)id)) {
            return defaultValue;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return defaultValue;
        }
        Object object = attribute.get();
        if (object == null) {
            return defaultValue;
        }
        return object.toString();
    }

    public static String getFullProviderURL(String baseURL, String baseDN) {
        return String.valueOf(baseURL) + "/" + baseDN;
    }

    public static Date parseDate(String date) throws Exception {
        String format = "yyyyMMddHHmmss";
        if (date.endsWith("Z")) {
            format = date.indexOf(46) != -1 ? "yyyyMMddHHmmss.S'Z'" : "yyyyMMddHHmmss'Z'";
        } else if (date.indexOf(45) != -1 || date.indexOf(43) != -1) {
            format = date.indexOf(46) != -1 ? "yyyyMMddHHmmss.SZ" : "yyyyMMddHHmmssZ";
        } else if (date.indexOf(46) != -1) {
            format = "yyyyMMddHHmmss.S";
        }
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)format);
        return dateFormat.parse(date);
    }
}

