/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.axis;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.servlet.UncommittedServletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.utils.cache.MethodCache;

public class AxisServlet
extends org.apache.axis.transport.http.AxisServlet {
    private static final String _CORRECT_LONG_ARRAY = "<complexType name=\"ArrayOf_xsd_long\"><complexContent><restriction base=\"soapenc:Array\"><attribute ref=\"soapenc:arrayType\" wsdl:arrayType=\"soapenc:long[]\"/></restriction></complexContent></complexType>";
    private static final String _CORRECT_STRING_ARRAY = "<complexType name=\"ArrayOf_xsd_string\"><complexContent><restriction base=\"soapenc:Array\"><attribute ref=\"soapenc:arrayType\" wsdl:arrayType=\"soapenc:string[]\"/></restriction></complexContent></complexType>";
    private static final String _HTML_BOTTOM_WRAPPER = "</body></html>";
    private static final String _HTML_TOP_WRAPPER = "<html><body>";
    private static final String _INCORRECT_LONG_ARRAY = "<complexType name=\"ArrayOf_xsd_long\"><simpleContent><extension/></simpleContent></complexType>";
    private static final String _INCORRECT_STRING_ARRAY = "<complexType name=\"ArrayOf_xsd_string\"><simpleContent><extension/></simpleContent></complexType>";
    private static Log _log = LogFactoryUtil.getLog(AxisServlet.class);
    private static Field _cacheField;
    private boolean _fixContent;
    private boolean _ready;
    private ServletConfig _servletConfig;

    static {
        try {
            _cacheField = ReflectionUtil.getDeclaredField(MethodCache.class, (String)"cache");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void destroy() {
        if (ServerDetector.isWebLogic()) {
            this.doDestroy();
        } else {
            DestroyThread destroyThread = new DestroyThread();
            destroyThread.start();
            try {
                destroyThread.join();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            Exception e = destroyThread.getException();
            if (e != null) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this._servletConfig = servletConfig;
        if (ServerDetector.isResin() || ServerDetector.isWebLogic()) {
            this.doInit();
        } else {
            InitThread initThread = new InitThread();
            initThread.start();
            try {
                initThread.join();
            }
            catch (InterruptedException ie) {
                throw new ServletException((Throwable)ie);
            }
            Exception e = initThread.getException();
            if (e != null) {
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (!this._ready) {
                return;
            }
            try {
                StringServletResponse stringResponse = new StringServletResponse(response);
                super.service(request, (HttpServletResponse)stringResponse);
                String contentType = stringResponse.getContentType();
                response.setContentType(contentType);
                String content = stringResponse.getString();
                if (this._fixContent) {
                    if (contentType.contains("text/html")) {
                        content = _HTML_TOP_WRAPPER.concat(content).concat(_HTML_BOTTOM_WRAPPER);
                    } else if (contentType.contains("text/xml")) {
                        content = this.fixXml(content);
                    }
                }
                ServletResponseUtil.write((HttpServletResponse)new UncommittedServletResponse(response), (byte[])content.getBytes("UTF-8"));
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (ServletException se) {
                throw se;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            try {
                ThreadLocal cache = (ThreadLocal)_cacheField.get(null);
                if (cache != null) {
                    cache.remove();
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void doDestroy() {
        this._ready = false;
        super.destroy();
    }

    protected void doInit() throws ServletException {
        super.init(this._servletConfig);
        this._fixContent = GetterUtil.getBoolean((String)this._servletConfig.getInitParameter("fix-content"), (boolean)true);
        this._ready = true;
    }

    protected String fixXml(String xml) throws Exception {
        if (xml.indexOf("<wsdl:definitions") == -1) {
            return xml;
        }
        xml = StringUtil.replace((String)xml, (String[])new String[]{"\r\n", "\n", "  ", "> <", _INCORRECT_LONG_ARRAY, _INCORRECT_STRING_ARRAY}, (String[])new String[]{"", "", "", "><", _CORRECT_LONG_ARRAY, _CORRECT_STRING_ARRAY});
        Document document = SAXReaderUtil.read((String)xml);
        return document.formattedString();
    }

    private class DestroyThread
    extends Thread {
        private Exception _exception;

        public DestroyThread() {
            this.setDaemon(true);
        }

        public Exception getException() {
            return this._exception;
        }

        public void run() {
            try {
                AxisServlet.this.doDestroy();
            }
            catch (Exception e) {
                this._exception = e;
            }
        }
    }

    private class InitThread
    extends Thread {
        private Exception _exception;

        public InitThread() {
            this.setDaemon(true);
        }

        public Exception getException() {
            return this._exception;
        }

        public void run() {
            try {
                AxisServlet.this.doInit();
            }
            catch (Exception e) {
                this._exception = e;
            }
        }
    }
}

