/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.Normalizer;
import com.liferay.util.RSSThreadLocal;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.util.List;
import org.jdom.IllegalDataException;

public class RSSUtil {
    public static final String ATOM = "atom";
    public static final double[] ATOM_VERSIONS = new double[]{0.3, 1.0};
    public static final String DISPLAY_STYLE_ABSTRACT = "abstract";
    public static final String DISPLAY_STYLE_FULL_CONTENT = "full-content";
    public static final String DISPLAY_STYLE_TITLE = "title";
    public static final String ENTRY_TYPE_DEFAULT = "html";
    public static final String FEED_TYPE_DEFAULT = RSSUtil.getFeedType("atom", 1.0);
    public static final String RSS = "rss";
    public static final double[] RSS_VERSIONS = new double[]{0.9, 0.91, 0.93, 0.94, 1.0, 2.0};
    public static final String TYPE_DEFAULT = "atom";
    public static final double VERSION_DEFAULT = 1.0;
    private static final String _REGEXP_STRIP = "[\\d\\w]";

    public static String export(SyndFeed feed) throws FeedException {
        RSSThreadLocal.setExportRSS(true);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            return output.outputString(feed);
        }
        catch (IllegalDataException illegalDataException) {
            RSSUtil._regexpStrip(feed);
            return output.outputString(feed);
        }
    }

    public static String getFeedType(String type, double version) {
        return String.valueOf(type) + "_" + version;
    }

    public static String getFormatType(String format) {
        if (format == null) {
            return "atom";
        }
        int x = format.indexOf("atom");
        if (x >= 0) {
            return "atom";
        }
        int y = format.indexOf(RSS);
        if (y >= 0) {
            return RSS;
        }
        return "atom";
    }

    public static double getFormatVersion(String format) {
        if (format == null) {
            return 1.0;
        }
        int x = format.indexOf("10");
        if (x >= 0) {
            return 1.0;
        }
        int y = format.indexOf("20");
        if (y >= 0) {
            return 2.0;
        }
        return 1.0;
    }

    private static String _regexpStrip(String text) {
        text = Normalizer.normalizeToAscii(text);
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            String s = String.valueOf(array[i]);
            if (!s.matches(_REGEXP_STRIP)) {
                array[i] = 32;
            }
            ++i;
        }
        return new String(array);
    }

    private static void _regexpStrip(SyndFeed syndFeed) {
        syndFeed.setTitle(RSSUtil._regexpStrip(syndFeed.getTitle()));
        syndFeed.setDescription(RSSUtil._regexpStrip(syndFeed.getDescription()));
        List syndEntries = syndFeed.getEntries();
        for (SyndEntry syndEntry : syndEntries) {
            syndEntry.setTitle(RSSUtil._regexpStrip(syndEntry.getTitle()));
            SyndContent syndContent = syndEntry.getDescription();
            syndContent.setValue(RSSUtil._regexpStrip(syndContent.getValue()));
        }
    }
}

