/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class CreditCard {
    public static String hide(String number) {
        return CreditCard.hide(number, "*");
    }

    public static String hide(String number, String x) {
        if (number == null) {
            return number;
        }
        int numberLen = number.length();
        if (numberLen > 4) {
            StringBundler sb = new StringBundler(numberLen - 3);
            int i = 0;
            while (i < numberLen - 4) {
                sb.append(x);
                ++i;
            }
            sb.append(number.substring(numberLen - 4, numberLen));
            number = sb.toString();
        }
        return number;
    }

    public static boolean isValidExpirationDate(int expirationMonth, int expirationYear) {
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)TimeZoneUtil.getDefault(), (Locale)LocaleUtil.getDefault());
        if (CalendarUtil.isFuture((int)expirationMonth, (int)expirationYear)) {
            return true;
        }
        return expirationMonth == calendar.get(2) && expirationYear == calendar.get(1);
    }

    public static boolean isValidNumber(String number, String type) {
        number = StringUtil.extractDigits((String)number);
        if (type.equals("visa")) {
            if (!number.startsWith("4")) {
                return false;
            }
            if (number.length() != 13 && number.length() != 16) {
                return false;
            }
        } else if (type.equals("mastercard")) {
            if (!(number.startsWith("51") || number.startsWith("52") || number.startsWith("53") || number.startsWith("54") || number.startsWith("55"))) {
                return false;
            }
            if (number.length() != 16) {
                return false;
            }
        } else if (type.equals("discover")) {
            if (!number.startsWith("6011")) {
                return false;
            }
            if (number.length() != 16) {
                return false;
            }
        } else if (type.equals("amex")) {
            if (!(number.startsWith("34") || number.startsWith("35") || number.startsWith("36") || number.startsWith("37"))) {
                return false;
            }
            if (number.length() != 15) {
                return false;
            }
        }
        return Validator.isLUHN((String)number);
    }
}

