/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.util.servlet.JettySharedSessionWrapper;
import com.liferay.util.servlet.SharedSessionWrapper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedSessionServletRequest
extends HttpServletRequestWrapper {
    private HttpSession _session;
    private Map<String, Object> _sharedSessionAttributes;
    private boolean _shared;

    public SharedSessionServletRequest(HttpServletRequest request, Map<String, Object> sharedSessionAttributes, boolean shared) {
        super(request);
        this._sharedSessionAttributes = sharedSessionAttributes;
        this._session = this.getSharedSessionWrapper(request.getSession());
        this._shared = shared;
    }

    public HttpSession getSession() {
        if (this._shared) {
            return this._session;
        }
        return this.getSharedSessionWrapper(super.getSession());
    }

    public HttpSession getSession(boolean create) {
        if (this._shared) {
            return this._session;
        }
        return this.getSharedSessionWrapper(super.getSession(create));
    }

    public HttpSession getSharedSession() {
        return this._session;
    }

    protected HttpSession getSharedSessionWrapper(HttpSession session) {
        if (ServerDetector.isJetty()) {
            return new JettySharedSessionWrapper(session, this._sharedSessionAttributes);
        }
        return new SharedSessionWrapper(session, this._sharedSessionAttributes);
    }
}

