/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.json;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.UnmarshallException;

public class JSONFactoryUtil {
    private static Log _log = LogFactoryUtil.getLog(JSONFactoryUtil.class);
    private static JSONFactoryUtil _instance = new JSONFactoryUtil();
    private JSONSerializer _serializer = new JSONSerializer();

    public static Object deserialize(JSONObject jsonObj) {
        return _instance._deserialize(jsonObj);
    }

    public static Object deserialize(String json) {
        return _instance._deserialize(json);
    }

    public static String serialize(Object obj) {
        return _instance._serialize(obj);
    }

    private JSONFactoryUtil() {
        try {
            this._serializer.registerDefaultSerializers();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private Object _deserialize(JSONObject jsonObj) {
        return this._deserialize(jsonObj.toString());
    }

    private Object _deserialize(String json) {
        try {
            return this._serializer.fromJSON(json);
        }
        catch (UnmarshallException ue) {
            _log.error((Object)ue, (Throwable)ue);
            throw new IllegalStateException("Unable to deserialize oject", ue);
        }
    }

    private String _serialize(Object obj) {
        try {
            return this._serializer.toJSON(obj);
        }
        catch (MarshallException me) {
            _log.error((Object)me, (Throwable)me);
            throw new IllegalStateException("Unable to serialize oject", me);
        }
    }
}

