/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.util.EncryptorException;
import com.liferay.util.SystemProperties;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class Encryptor {
    public static final String ENCODING = "UTF-8";
    public static final String KEY_ALGORITHM = "DES";
    public static final String SUN_PROVIDER_CLASS = "com.sun.crypto.provider.SunJCE";
    public static final String IBM_PROVIDER_CLASS = "com.ibm.crypto.provider.IBMJCE";
    public static final String PROVIDER_CLASS = GetterUtil.getString((String)SystemProperties.get(Encryptor.class.getName() + ".provider.class"), (String)"com.sun.crypto.provider.SunJCE");
    private static Log _log = LogFactoryUtil.getLog(Encryptor.class);

    public static Key generateKey() throws EncryptorException {
        return Encryptor.generateKey(KEY_ALGORITHM);
    }

    public static Key generateKey(String algorithm) throws EncryptorException {
        try {
            Security.addProvider(Encryptor.getProvider());
            KeyGenerator generator = KeyGenerator.getInstance(algorithm);
            generator.init(56, new SecureRandom());
            SecretKey key = generator.generateKey();
            return key;
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static Provider getProvider() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> providerClass = null;
        try {
            providerClass = Class.forName(PROVIDER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            if (ServerDetector.isWebSphere() && PROVIDER_CLASS.equals(SUN_PROVIDER_CLASS)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"WebSphere does not have com.sun.crypto.provider.SunJCE, using com.ibm.crypto.provider.IBMJCE instead");
                }
                providerClass = Class.forName(IBM_PROVIDER_CLASS);
            }
            if (System.getProperty("java.vm.vendor").equals("IBM Corporation")) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"IBM JVM does not have com.sun.crypto.provider.SunJCE, using com.ibm.crypto.provider.IBMJCE instead");
                }
                providerClass = Class.forName(IBM_PROVIDER_CLASS);
            }
            throw cnfe;
        }
        return (Provider)providerClass.newInstance();
    }

    public static String decrypt(Key key, String encryptedString) throws EncryptorException {
        byte[] encryptedBytes = Base64.decode((String)encryptedString);
        return Encryptor.decryptUnencodedAsString(key, encryptedBytes);
    }

    public static byte[] decryptUnencodedAsBytes(Key key, byte[] encryptedBytes) throws EncryptorException {
        try {
            Security.addProvider(Encryptor.getProvider());
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            return cipher.doFinal(encryptedBytes);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static String decryptUnencodedAsString(Key key, byte[] encryptedBytes) throws EncryptorException {
        try {
            byte[] decryptedBytes = Encryptor.decryptUnencodedAsBytes(key, encryptedBytes);
            return new String(decryptedBytes, ENCODING);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static String digest(String text) {
        return DigesterUtil.digest((String)text);
    }

    public static String digest(String algorithm, String text) {
        return DigesterUtil.digest((String)algorithm, (String[])new String[]{text});
    }

    public static String encrypt(Key key, String plainText) throws EncryptorException {
        byte[] encryptedBytes = Encryptor.encryptUnencoded(key, plainText);
        return Base64.encode((byte[])encryptedBytes);
    }

    public static byte[] encryptUnencoded(Key key, byte[] plainBytes) throws EncryptorException {
        try {
            Security.addProvider(Encryptor.getProvider());
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(1, key);
            return cipher.doFinal(plainBytes);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static byte[] encryptUnencoded(Key key, String plainText) throws EncryptorException {
        try {
            byte[] decryptedBytes = plainText.getBytes(ENCODING);
            return Encryptor.encryptUnencoded(key, decryptedBytes);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }
}

