/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.mail;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.Account;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.mail.SMTPAccount;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.mail.LiferayMimeMessage;
import com.liferay.util.mail.MailEngineException;
import java.io.File;
import java.io.InputStream;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.time.StopWatch;

public class MailEngine {
    private static final String _MULTIPART_TYPE_ALTERNATIVE = "alternative";
    private static final String _MULTIPART_TYPE_MIXED = "mixed";
    private static final String _TEXT_HTML = "text/html;charset=\"UTF-8\"";
    private static final String _TEXT_PLAIN = "text/plain;charset=\"UTF-8\"";
    private static Log _log = LogFactoryUtil.getLog(MailEngine.class);

    public static Session getSession() {
        return MailEngine.getSession(false);
    }

    public static Session getSession(boolean cache) {
        Session session = null;
        try {
            session = MailServiceUtil.getSession();
        }
        catch (SystemException se) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)se, (Throwable)se);
            }
            session = InfrastructureUtil.getMailSession();
        }
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            session.getProperties().list(System.out);
        }
        return session;
    }

    public static Session getSession(Account account) {
        Properties properties = MailEngine._getProperties(account);
        Session session = Session.getInstance((Properties)properties);
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            session.getProperties().list(System.out);
        }
        return session;
    }

    public static void send(MailMessage mailMessage) throws MailEngineException {
        MailEngine.send(mailMessage.getFrom(), mailMessage.getTo(), mailMessage.getCC(), mailMessage.getBCC(), mailMessage.getBulkAddresses(), mailMessage.getSubject(), mailMessage.getBody(), mailMessage.isHTMLFormat(), mailMessage.getReplyTo(), mailMessage.getMessageId(), mailMessage.getInReplyTo(), mailMessage.getAttachments(), mailMessage.getSMTPAccount());
    }

    public static void send(String from, String to, String subject, String body) throws MailEngineException {
        try {
            MailEngine.send(new InternetAddress(from), new InternetAddress(to), subject, body);
        }
        catch (AddressException ae) {
            throw new MailEngineException(ae);
        }
    }

    public static void send(InternetAddress from, InternetAddress to, String subject, String body) throws MailEngineException {
        MailEngine.send(from, new InternetAddress[]{to}, null, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress to, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, new InternetAddress[]{to}, null, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, null, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, to, null, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, cc, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, to, cc, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, null, subject, body, htmlFormat, replyTo, messageId, inReplyTo, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, InternetAddress[] bulkAddresses, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, bulkAddresses, subject, body, htmlFormat, replyTo, messageId, inReplyTo, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, InternetAddress[] bulkAddresses, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo, File[] attachments) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, bulkAddresses, subject, body, htmlFormat, replyTo, messageId, inReplyTo, attachments, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, InternetAddress[] bulkAddresses, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo, File[] attachments, SMTPAccount smtpAccount) throws MailEngineException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
            _log.debug((Object)("From: " + from));
            _log.debug((Object)("To: " + Arrays.toString(to)));
            _log.debug((Object)("CC: " + Arrays.toString(cc)));
            _log.debug((Object)("BCC: " + Arrays.toString(bcc)));
            _log.debug((Object)("List Addresses: " + Arrays.toString(bulkAddresses)));
            _log.debug((Object)("Subject: " + subject));
            _log.debug((Object)("Body: " + body));
            _log.debug((Object)("HTML Format: " + htmlFormat));
            _log.debug((Object)("Reply to: " + Arrays.toString(replyTo)));
            _log.debug((Object)("Message ID: " + messageId));
            _log.debug((Object)("In Reply To: " + inReplyTo));
            if (attachments != null) {
                for (int i = 0; i < attachments.length; ++i) {
                    File attachment = attachments[i];
                    if (attachment == null) continue;
                    String path = attachment.getAbsolutePath();
                    _log.debug((Object)("Attachment #" + (i + 1) + ": " + path));
                }
            }
        }
        try {
            Session session = null;
            session = smtpAccount == null ? MailEngine.getSession() : MailEngine.getSession((Account)smtpAccount);
            LiferayMimeMessage msg = new LiferayMimeMessage(session);
            msg.setFrom((Address)from);
            msg.setRecipients(Message.RecipientType.TO, (Address[])to);
            if (cc != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])cc);
            }
            if (bcc != null) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
            }
            msg.setSubject(subject);
            if (attachments != null && attachments.length > 0) {
                MimeBodyPart bodyPart;
                MimeMultipart rootMultipart = new MimeMultipart(_MULTIPART_TYPE_MIXED);
                MimeMultipart messageMultipart = new MimeMultipart(_MULTIPART_TYPE_ALTERNATIVE);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Multipart)messageMultipart);
                rootMultipart.addBodyPart((BodyPart)messageBodyPart);
                if (htmlFormat) {
                    bodyPart = new MimeBodyPart();
                    bodyPart.setContent((Object)body, _TEXT_HTML);
                    messageMultipart.addBodyPart((BodyPart)bodyPart);
                } else {
                    bodyPart = new MimeBodyPart();
                    bodyPart.setText(body);
                    messageMultipart.addBodyPart((BodyPart)bodyPart);
                }
                for (int i = 0; i < attachments.length; ++i) {
                    File attachment = attachments[i];
                    if (attachment == null) continue;
                    MimeBodyPart bodyPart2 = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(attachment);
                    bodyPart2.setDisposition("attachment");
                    bodyPart2.setDataHandler(new DataHandler((DataSource)source));
                    bodyPart2.setFileName(attachment.getName());
                    rootMultipart.addBodyPart((BodyPart)bodyPart2);
                }
                msg.setContent((Multipart)rootMultipart);
                msg.saveChanges();
            } else if (htmlFormat) {
                msg.setContent(body, _TEXT_HTML);
            } else {
                msg.setContent(body, _TEXT_PLAIN);
            }
            msg.setSentDate(new Date());
            if (replyTo != null) {
                msg.setReplyTo((Address[])replyTo);
            }
            if (messageId != null) {
                msg.setHeader("Message-ID", messageId);
            }
            if (inReplyTo != null) {
                msg.setHeader("In-Reply-To", inReplyTo);
                msg.setHeader("References", inReplyTo);
            }
            MailEngine._send(session, (Message)msg, bulkAddresses);
        }
        catch (SendFailedException sfe) {
            _log.error((Throwable)sfe);
        }
        catch (Exception e) {
            throw new MailEngineException(e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending mail takes " + stopWatch.getTime() + " ms"));
        }
    }

    public static void send(byte[] msgByteArray) throws MailEngineException {
        try {
            Session session = MailEngine.getSession();
            MimeMessage msg = new MimeMessage(session, (InputStream)new UnsyncByteArrayInputStream(msgByteArray));
            MailEngine._send(session, (Message)msg, null);
        }
        catch (Exception e) {
            throw new MailEngineException(e);
        }
    }

    private static Properties _getProperties(Account account) {
        Properties properties = new Properties();
        String protocol = account.getProtocol();
        properties.setProperty("mail.transport.protocol", protocol);
        properties.setProperty("mail." + protocol + ".host", account.getHost());
        properties.setProperty("mail." + protocol + ".port", String.valueOf(account.getPort()));
        if (account.isRequiresAuthentication()) {
            properties.setProperty("mail." + protocol + ".auth", "true");
            properties.setProperty("mail." + protocol + ".user", account.getUser());
            properties.setProperty("mail." + protocol + ".password", account.getPassword());
        }
        if (account.isSecure()) {
            properties.setProperty("mail." + protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.setProperty("mail." + protocol + ".socketFactory.fallback", "false");
            properties.setProperty("mail." + protocol + ".socketFactory.port", String.valueOf(account.getPort()));
        }
        return properties;
    }

    private static String _getSMTPProperty(Session session, String suffix) {
        String protocol = GetterUtil.getString((String)session.getProperty("mail.transport.protocol"));
        if (protocol.equals("smtps")) {
            return session.getProperty("mail.smtps." + suffix);
        }
        return session.getProperty("mail.smtp." + suffix);
    }

    private static void _send(Session session, Message msg, InternetAddress[] bulkAddresses) {
        block8: {
            try {
                boolean smtpAuth = GetterUtil.getBoolean((String)MailEngine._getSMTPProperty(session, "auth"), (boolean)false);
                String smtpHost = MailEngine._getSMTPProperty(session, "host");
                int smtpPort = GetterUtil.getInteger((String)MailEngine._getSMTPProperty(session, "port"), (int)25);
                String user = MailEngine._getSMTPProperty(session, "user");
                String password = MailEngine._getSMTPProperty(session, "password");
                if (smtpAuth && Validator.isNotNull((String)user) && Validator.isNotNull((String)password)) {
                    String protocol = GetterUtil.getString((String)session.getProperty("mail.transport.protocol"), (String)"smtp");
                    Transport transport = session.getTransport(protocol);
                    transport.connect(smtpHost, smtpPort, user, password);
                    if (bulkAddresses != null && bulkAddresses.length > 0) {
                        transport.sendMessage(msg, (Address[])bulkAddresses);
                    } else {
                        transport.sendMessage(msg, msg.getAllRecipients());
                    }
                    transport.close();
                } else if (bulkAddresses != null && bulkAddresses.length > 0) {
                    Transport.send((Message)msg, (Address[])bulkAddresses);
                } else {
                    Transport.send((Message)msg);
                }
            }
            catch (MessagingException me) {
                if (!(me.getNextException() instanceof SocketException) || !_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Failed to connect to a valid mail server. Please make sure one is properly configured. " + me.getMessage()));
            }
        }
    }
}

