/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.diff;

import com.liferay.portal.kernel.util.StringBundler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResult {
    public static final String SOURCE = "SOURCE";
    public static final String TARGET = "TARGET";
    private int _lineNumber;
    private List<String> _changedLines;

    public DiffResult(int linePos, List<String> changedLines) {
        this._lineNumber = linePos + 1;
        this._changedLines = changedLines;
    }

    public DiffResult(int linePos, String changedLine) {
        this._lineNumber = linePos + 1;
        this._changedLines = new ArrayList<String>();
        this._changedLines.add(changedLine);
    }

    public List<String> getChangedLines() {
        return this._changedLines;
    }

    public void setChangedLines(List<String> changedLines) {
        this._changedLines = changedLines;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this._lineNumber = lineNumber;
    }

    public boolean equals(Object obj) {
        DiffResult diffResult = (DiffResult)obj;
        return diffResult.getLineNumber() == this._lineNumber && ((Object)diffResult.getChangedLines()).equals(this._changedLines);
    }

    public String toString() {
        StringBundler sb = new StringBundler(this._changedLines.size() * 2 + 3);
        sb.append("Line: ");
        sb.append(this._lineNumber);
        sb.append("\n");
        Iterator<String> itr = this._changedLines.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
            if (!itr.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

