/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.NumberFormat;
import java.util.Locale;

public class TextFormatter {
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    public static final int D = 3;
    public static final int E = 4;
    public static final int F = 5;
    public static final int G = 6;
    public static final int H = 7;
    public static final int I = 8;
    public static final int J = 9;
    public static final int K = 10;
    public static final int L = 11;
    public static final int M = 12;
    public static final int N = 13;
    public static final int O = 14;

    public static String format(String s, int style) {
        if (Validator.isNull((String)s)) {
            return null;
        }
        s = s.trim();
        if (style == 0) {
            return TextFormatter._formatA(s);
        }
        if (style == 1) {
            return TextFormatter._formatB(s);
        }
        if (style == 2) {
            return TextFormatter._formatC(s);
        }
        if (style == 3) {
            return TextFormatter._formatD(s);
        }
        if (style == 4) {
            return TextFormatter._formatE(s);
        }
        if (style == 5) {
            return TextFormatter._formatF(s);
        }
        if (style == 6) {
            return TextFormatter._formatG(s);
        }
        if (style == 7) {
            return TextFormatter._formatH(s);
        }
        if (style == 8) {
            return TextFormatter._formatI(s);
        }
        if (style == 9) {
            return TextFormatter._formatJ(s);
        }
        if (style == 10) {
            return TextFormatter._formatK(s);
        }
        if (style == 11) {
            return TextFormatter._formatL(s);
        }
        if (style == 12) {
            return TextFormatter._formatM(s);
        }
        if (style == 13) {
            return TextFormatter._formatN(s);
        }
        if (style == 14) {
            return TextFormatter._formatO(s);
        }
        return s;
    }

    public static String formatKB(double size, Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(1);
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat.format(size / 1024.0);
    }

    public static String formatKB(int size, Locale locale) {
        return TextFormatter.formatKB((double)size, locale);
    }

    public static String formatName(String name) {
        if (Validator.isNull((String)name)) {
            return name;
        }
        char[] charArray = name.toLowerCase().trim().toCharArray();
        if (charArray.length > 0) {
            charArray[0] = Character.toUpperCase(charArray[0]);
        }
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != ' ') continue;
            charArray[i + 1] = Character.toUpperCase(charArray[i + 1]);
        }
        return new String(charArray);
    }

    public static String formatPlural(String s) {
        if (Validator.isNull((String)s)) {
            return s;
        }
        s = s.endsWith("s") ? s.substring(0, s.length() - 1) + "ses" : (s.endsWith("y") ? s.substring(0, s.length() - 1) + "ies" : s + "s");
        return s;
    }

    private static String _formatA(String s) {
        return StringUtil.replace((String)s.toUpperCase(), (String)" ", (String)"_");
    }

    private static String _formatB(String s) {
        return StringUtil.replace((String)s.toLowerCase(), (String)" ", (String)"");
    }

    private static String _formatC(String s) {
        return StringUtil.replace((String)s.toLowerCase(), (String)" ", (String)"_");
    }

    private static String _formatD(String s) {
        return StringUtil.replace((String)s, (String)" ", (String)"");
    }

    private static String _formatE(String s) {
        return s.toLowerCase();
    }

    private static String _formatF(String s) {
        s = StringUtil.replace((String)s, (String)" ", (String)"");
        s = Character.toLowerCase(s.charAt(0)) + s.substring(1, s.length());
        return s;
    }

    private static String _formatG(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
    }

    private static String _formatH(String s) {
        char[] charArray = s.toCharArray();
        StringBuilder sb = new StringBuilder(charArray.length * 2);
        for (int i = 0; i < charArray.length; ++i) {
            if (Character.isUpperCase(charArray[i])) {
                sb.append(" ");
                sb.append(Character.toLowerCase(charArray[i]));
                continue;
            }
            sb.append(charArray[i]);
        }
        return sb.toString().trim();
    }

    private static String _formatI(String s) {
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        if (Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1))) {
            return Character.toLowerCase(s.charAt(0)) + s.substring(1, s.length());
        }
        char[] charArray = s.toCharArray();
        StringBuilder sb = new StringBuilder(charArray.length);
        for (int i = 0; i < charArray.length; ++i) {
            if (i + 1 != charArray.length && Character.isLowerCase(charArray[i + 1])) {
                sb.append(s.substring(i, charArray.length));
                break;
            }
            sb.append(Character.toLowerCase(charArray[i]));
        }
        return sb.toString();
    }

    private static String _formatJ(String s) {
        s = StringUtil.replace((String)s, (String)"-", (String)" ");
        s = StringUtil.replace((String)s, (String)"_", (String)" ");
        char[] charArray = s.toCharArray();
        StringBuilder sb = new StringBuilder(charArray.length);
        for (int i = 0; i < charArray.length; ++i) {
            if (i == 0 || charArray[i - 1] == ' ') {
                sb.append(Character.toUpperCase(charArray[i]));
                continue;
            }
            sb.append(Character.toLowerCase(charArray[i]));
        }
        return sb.toString();
    }

    private static String _formatK(String s) {
        s = TextFormatter._formatH(s);
        s = StringUtil.replace((String)s, (String)" ", (String)"-");
        return s;
    }

    private static String _formatL(String s) {
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        if (Character.isUpperCase(s.charAt(0)) && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private static String _formatM(String s) {
        char[] charArray = s.toCharArray();
        StringBuilder sb = new StringBuilder(charArray.length);
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '-') continue;
            if (i > 0 && charArray[i - 1] == '-') {
                sb.append(Character.toUpperCase(charArray[i]));
                continue;
            }
            sb.append(charArray[i]);
        }
        return sb.toString();
    }

    private static String _formatN(String s) {
        return StringUtil.replace((String)s, (String)"-", (String)"_");
    }

    private static String _formatO(String s) {
        return StringUtil.replace((String)s, (String)"_", (String)"-");
    }
}

