/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class CreditCard {
    public static String hide(String number) {
        return CreditCard.hide(number, "*");
    }

    public static String hide(String number, String x) {
        if (number == null) {
            return number;
        }
        int numberLen = number.length();
        if (numberLen > 4) {
            StringBundler sb = new StringBundler(numberLen - 3);
            for (int i = 0; i < numberLen - 4; ++i) {
                sb.append(x);
            }
            sb.append(number.substring(numberLen - 4, numberLen));
            number = sb.toString();
        }
        return number;
    }

    public static boolean isValid(String number, String type) {
        number = StringUtil.extractDigits((String)number);
        if (type.equals("visa")) {
            if (!number.startsWith("4")) {
                return false;
            }
            if (number.length() != 13 && number.length() != 16) {
                return false;
            }
        } else if (type.equals("mastercard")) {
            if (!(number.startsWith("51") || number.startsWith("52") || number.startsWith("53") || number.startsWith("54") || number.startsWith("55"))) {
                return false;
            }
            if (number.length() != 16) {
                return false;
            }
        } else if (type.equals("discover")) {
            if (!number.startsWith("6011")) {
                return false;
            }
            if (number.length() != 16) {
                return false;
            }
        } else if (type.equals("amex")) {
            if (!(number.startsWith("34") || number.startsWith("35") || number.startsWith("36") || number.startsWith("37"))) {
                return false;
            }
            if (number.length() != 15) {
                return false;
            }
        }
        return Validator.isLUHN((String)number);
    }
}

