/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml.descriptor;

import com.liferay.util.xml.ElementComparator;
import com.liferay.util.xml.ElementIdentifier;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class SimpleXMLDescriptor
implements XMLDescriptor {
    public boolean areEqual(Element el1, Element el2) {
        int i;
        String name1 = el1.getName();
        String name2 = el2.getName();
        if (name1 == null || !name1.equals(name2)) {
            return false;
        }
        if (this._isIncluded(el1, this.getUniqueElements())) {
            return true;
        }
        ElementIdentifier[] elIds = this.getElementsIdentifiedByAttribute();
        for (i = 0; i < elIds.length; ++i) {
            if (!name1.equals(elIds[i].getElementName())) continue;
            return this._compareAttribute(el1, el2, elIds[i].getIdentifierName()) == 0;
        }
        elIds = this.getElementsIdentifiedByChild();
        for (i = 0; i < elIds.length; ++i) {
            if (!name1.equals(elIds[i].getElementName())) continue;
            return this._compareChildText(el1, el2, elIds[i].getIdentifierName()) == 0;
        }
        ElementComparator comparator = new ElementComparator();
        return comparator.compare(el1, el2) == 0;
    }

    public abstract boolean canHandleType(String var1, Document var2);

    public boolean canJoinChildren(Element element) {
        return this._isIncluded(element, this.getJoinableElements());
    }

    public String[] getRootChildrenOrder() {
        return new String[0];
    }

    public String[] getChildrenOrder(Element parentElement) {
        return new String[0];
    }

    public ElementIdentifier[] getElementsIdentifiedByAttribute() {
        return new ElementIdentifier[0];
    }

    public ElementIdentifier[] getElementsIdentifiedByChild() {
        return new ElementIdentifier[0];
    }

    public String[] getUniqueElements() {
        return new String[0];
    }

    public String[] getJoinableElements() {
        return new String[0];
    }

    private int _compareAttribute(Element el1, Element el2, String attrName) {
        String name1 = el1.attributeValue(attrName);
        String name2 = el2.attributeValue(attrName);
        if (name1 == null || name2 == null) {
            return -1;
        }
        return name1.compareTo(name2);
    }

    private int _compareChildText(Element el1, Element el2, String childName) {
        Element child1 = this._getChild(el1, childName);
        Element child2 = this._getChild(el2, childName);
        if (child1 == null || child2 == null) {
            return -1;
        }
        String name1 = child1.getText();
        String name2 = child2.getText();
        if (name1 == null || name2 == null) {
            return -1;
        }
        return name1.compareTo(name2);
    }

    private Element _getChild(Element parent, String childName) {
        Element child = parent.element(childName);
        return child;
    }

    private boolean _isIncluded(Element element, String[] elemNames) {
        for (int i = 0; i < elemNames.length; ++i) {
            if (!element.getName().equals(elemNames[i])) continue;
            return true;
        }
        return false;
    }
}

