/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.spring.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;

public class TransactionStatusClp
implements TransactionStatus {
    private static Log _log = LogFactoryUtil.getLog(TransactionStatusClp.class);
    private static Map<String, Method> _remoteMethods;
    private Object _remoteTransactionStatus;

    public TransactionStatusClp(Object remoteTransactionStatus) {
        this._remoteTransactionStatus = remoteTransactionStatus;
        if (_remoteMethods == null) {
            this.initRemoteMethods(remoteTransactionStatus);
        }
    }

    public Object createSavepoint() throws TransactionException {
        try {
            Method method = _remoteMethods.get("createSavepoint");
            return method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new TransactionSystemException(e.getMessage());
        }
    }

    public void flush() {
        try {
            Method method = _remoteMethods.get("flush");
            method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new TransactionSystemException(e.getMessage());
        }
    }

    public Object getRemoteTransactionStatus() {
        return this._remoteTransactionStatus;
    }

    public boolean hasSavepoint() {
        try {
            Method method = _remoteMethods.get("hasSavepoint");
            return (Boolean)method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isCompleted() {
        try {
            Method method = _remoteMethods.get("isCompleted");
            return (Boolean)method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isNewTransaction() {
        try {
            Method method = _remoteMethods.get("isNewTransaction");
            return (Boolean)method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isRollbackOnly() {
        try {
            Method method = _remoteMethods.get("isRollbackOnly");
            return (Boolean)method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void releaseSavepoint(Object savepoint) throws TransactionException {
        try {
            Method method = _remoteMethods.get("releaseSavepoint");
            method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new TransactionSystemException(e.getMessage());
        }
    }

    public void rollbackToSavepoint(Object savepoint) throws TransactionException {
        try {
            Method method = _remoteMethods.get("rollbackToSavepoint");
            method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new TransactionSystemException(e.getMessage());
        }
    }

    public void setRollbackOnly() {
        try {
            Method method = _remoteMethods.get("setRollbackOnly");
            method.invoke(this._remoteTransactionStatus, new Object[0]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void initRemoteMethods(Object remoteTransactionStatus) {
        Method[] methods;
        _remoteMethods = new HashMap<String, Method>();
        for (Method method : methods = TransactionStatus.class.getMethods()) {
            _remoteMethods.put(method.getName(), method);
        }
    }
}

