/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.axis;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.util.SystemProperties;
import com.liferay.util.axis.SimpleAuthenticator;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Pattern;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPSender;

public class SimpleHTTPSender
extends HTTPSender {
    private static Log _log = LogFactoryUtil.getLog(SimpleHTTPSender.class);
    private static ThreadLocal<String> _currentCookie = new InitialThreadLocal(SimpleHTTPSender.class + "._currentCookie", (Object)"");
    private static Pattern _pattern = Pattern.compile(SystemProperties.get(SimpleHTTPSender.class.getName() + ".regexp.pattern"));

    public static String getCurrentCookie() {
        return _currentCookie.get();
    }

    public void invoke(MessageContext ctx) throws AxisFault {
        String url = ctx.getStrProp("transport.url");
        if (_pattern.matcher(url).matches()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("A match was found for " + url));
            }
            this._invoke(ctx, url);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No match was found for " + url));
            }
            super.invoke(ctx);
            this._registerCurrentCookie(ctx);
        }
    }

    private void _invoke(MessageContext ctx, String url) throws AxisFault {
        try {
            String userName = ctx.getUsername();
            String password = ctx.getPassword();
            if (userName != null && password != null) {
                Authenticator.setDefault(new SimpleAuthenticator(userName, password));
            }
            URL urlObj = new URL(url);
            URLConnection urlc = urlObj.openConnection();
            this._writeToConnection(urlc, ctx);
            this._readFromConnection(urlc, ctx);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        finally {
            Authenticator.setDefault(null);
        }
    }

    private void _readFromConnection(URLConnection urlc, MessageContext ctx) throws Exception {
        String contentType = urlc.getContentType();
        String contentLocation = urlc.getHeaderField("Content-Location");
        InputStream is = ((HttpURLConnection)urlc).getErrorStream();
        if (is == null) {
            is = urlc.getInputStream();
        }
        is = new UnsyncBufferedInputStream(is, 8192);
        Message response = new Message((Object)is, false, contentType, contentLocation);
        response.setMessageType("response");
        ctx.setResponseMessage(response);
    }

    private void _registerCurrentCookie(MessageContext ctx) {
        String cookie = "";
        try {
            cookie = GetterUtil.getString((String)ctx.getStrProp("Cookie"));
        }
        catch (Throwable t) {
            _log.warn(t);
        }
        _currentCookie.set(cookie);
    }

    private void _writeToConnection(URLConnection urlc, MessageContext ctx) throws Exception {
        urlc.setDoOutput(true);
        Message request = ctx.getRequestMessage();
        String contentType = request.getContentType(ctx.getSOAPConstants());
        urlc.setRequestProperty("Content-Type", contentType);
        if (ctx.useSOAPAction()) {
            urlc.setRequestProperty("SOAPAction", ctx.getSOAPActionURI());
        }
        UnsyncBufferedOutputStream os = new UnsyncBufferedOutputStream(urlc.getOutputStream(), 8192);
        request.writeTo((OutputStream)os);
        os.flush();
    }
}

