/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ant;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.util.ant.AntUtil;
import com.liferay.util.ant.DeleteTask;
import com.liferay.util.xml.XMLFormatter;
import java.io.File;
import java.io.IOException;
import org.apache.axis.tools.ant.wsdl.Java2WsdlAntTask;
import org.apache.axis.tools.ant.wsdl.NamespaceMapping;
import org.apache.axis.tools.ant.wsdl.Wsdl2javaAntTask;
import org.apache.tools.ant.Project;
import org.dom4j.DocumentException;

public class Java2WsddTask {
    public static String[] generateWsdd(String className, String serviceName) throws IOException {
        File tempDir = new File(Time.getTimestamp());
        tempDir.mkdir();
        String wsdlFileName = tempDir + "/service.wsdl";
        int pos = className.lastIndexOf(".");
        String packagePath = className.substring(0, pos);
        String[] packagePaths = StringUtil.split((String)packagePath, (String)".");
        String namespace = "urn:";
        for (int i = packagePaths.length - 1; i >= 0; --i) {
            namespace = namespace + packagePaths[i];
            if (i <= 0) continue;
            namespace = namespace + ".";
        }
        String location = "http://localhost/services/" + serviceName;
        String mappingPackage = packagePath.substring(0, packagePath.lastIndexOf(".")) + ".ws";
        Project project = AntUtil.getProject();
        Java2WsdlAntTask java2Wsdl = new Java2WsdlAntTask();
        NamespaceMapping mapping = new NamespaceMapping();
        mapping.setNamespace(namespace);
        mapping.setPackage(mappingPackage);
        java2Wsdl.setProject(project);
        java2Wsdl.setClassName(className);
        java2Wsdl.setOutput(new File(wsdlFileName));
        java2Wsdl.setLocation(location);
        java2Wsdl.setNamespace(namespace);
        java2Wsdl.addMapping(mapping);
        java2Wsdl.execute();
        Wsdl2javaAntTask wsdl2Java = new Wsdl2javaAntTask();
        wsdl2Java.setProject(project);
        wsdl2Java.setURL(wsdlFileName);
        wsdl2Java.setOutput(tempDir);
        wsdl2Java.setServerSide(true);
        wsdl2Java.setTestCase(false);
        wsdl2Java.setVerbose(false);
        wsdl2Java.execute();
        String deployContent = FileUtil.read((String)(tempDir + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/") + "/deploy.wsdd"));
        deployContent = StringUtil.replace((String)deployContent, (String)(packagePath + "." + serviceName + "SoapBindingImpl"), (String)className);
        deployContent = Java2WsddTask._format(deployContent);
        String undeployContent = FileUtil.read((String)(tempDir + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/") + "/undeploy.wsdd"));
        undeployContent = Java2WsddTask._format(undeployContent);
        DeleteTask.deleteDirectory(tempDir);
        return new String[]{deployContent, undeployContent};
    }

    private static String _format(String content) throws IOException {
        content = HtmlUtil.stripComments((String)content);
        try {
            content = XMLFormatter.toString(content);
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        content = StringUtil.replace((String)content, (String)"\"/>", (String)"\" />");
        return content;
    }
}

