/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.portal.kernel.util.ByteArrayMaker;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLFormatter {
    public static String fixProlog(String xml) {
        if (xml != null) {
            char[] charArray = xml.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                if (charArray[i] != '<') continue;
                if (i == 0) break;
                xml = xml.substring(i, xml.length());
                break;
            }
        }
        return xml;
    }

    public static String fromCompactSafe(String xml) {
        return StringUtil.replace((String)xml, (String)"[$NEW_LINE$]", (String)"\n");
    }

    public static String toCompactSafe(String xml) {
        return StringUtil.replace((String)xml, (String[])new String[]{"\r\n", "\n", "\r"}, (String[])new String[]{"[$NEW_LINE$]", "[$NEW_LINE$]", "[$NEW_LINE$]"});
    }

    public static String toString(String xml) throws DocumentException, IOException {
        return XMLFormatter.toString(xml, "\t");
    }

    public static String toString(String xml, String indent) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(xml));
        return XMLFormatter.toString((Branch)doc, indent);
    }

    public static String toString(Branch branch) throws IOException {
        return XMLFormatter.toString(branch, "\t");
    }

    public static String toString(Branch branch, String indent) throws IOException {
        return XMLFormatter.toString(branch, "\t", false);
    }

    public static String toString(Branch branch, String indent, boolean expandEmptyElements) throws IOException {
        ByteArrayMaker bam = new ByteArrayMaker();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setExpandEmptyElements(expandEmptyElements);
        format.setIndent(indent);
        format.setLineSeparator("\n");
        XMLWriter writer = new XMLWriter((OutputStream)bam, format);
        writer.write((Node)branch);
        String content = bam.toString("UTF-8");
        if (content.endsWith("\n\n")) {
            content = content.substring(0, content.length() - 2);
        }
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        while (content.indexOf(" \n") != -1) {
            content = StringUtil.replace((String)content, (String)" \n", (String)"\n");
        }
        return content;
    }
}

