/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.util.transport.DatagramHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.util.zip.GZIPInputStream;

public class MulticastDatagramHandler
implements DatagramHandler {
    private static final Log _log = LogFactoryUtil.getLog(MulticastDatagramHandler.class);
    private boolean _gzipData;
    private boolean _shortData;

    public MulticastDatagramHandler(boolean gzipData, boolean shortData) {
        this._gzipData = gzipData;
        this._shortData = shortData;
    }

    public void errorReceived(Throwable t) {
        _log.error((Object)t, t);
    }

    public void process(DatagramPacket packet) {
        byte[] bytes = packet.getData();
        if (this._gzipData) {
            try {
                bytes = this.getUnzippedBytes(bytes);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (this._shortData) {
            byte[] temp = new byte[96];
            System.arraycopy(bytes, 0, temp, 0, 96);
            bytes = temp;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(packet.getSocketAddress());
        sb.append("] ");
        sb.append(new String(bytes));
        if (_log.isInfoEnabled()) {
            _log.info((Object)sb);
        }
    }

    protected byte[] getUnzippedBytes(byte[] bytes) throws Exception {
        GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        byte[] buffer = new byte[1500];
        int c = 0;
        while (c != -1) {
            c = ((InputStream)is).read(buffer, 0, 1500);
            if (c == -1) continue;
            baos.write(buffer, 0, c);
        }
        ((InputStream)is).close();
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }
}

