/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.CharUtils;

public class ServletResponseUtil {
    private static final String _CLIENT_ABORT_EXCEPTION = "org.apache.catalina.connector.ClientAbortException";
    private static Log _log = LogFactoryUtil.getLog(ServletResponseUtil.class);

    public static void cleanUp(InputStream is) {
        block3: {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)e);
            }
        }
    }

    public static void cleanUp(OutputStream os) {
        block7: {
            block6: {
                try {
                    if (os != null) {
                        os.flush();
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Throwable)e);
                }
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Throwable)e);
            }
        }
    }

    public static void cleanUp(OutputStream os, InputStream is) {
        ServletResponseUtil.cleanUp(os);
        ServletResponseUtil.cleanUp(is);
    }

    public static void sendFile(HttpServletResponse response, String fileName, byte[] bytes) throws IOException {
        ServletResponseUtil.sendFile(response, fileName, bytes, null);
    }

    public static void sendFile(HttpServletResponse response, String fileName, byte[] bytes, String contentType) throws IOException {
        ServletResponseUtil.setHeaders(response, fileName, contentType);
        ServletResponseUtil.write(response, bytes);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is) throws IOException {
        ServletResponseUtil.sendFile(response, fileName, is, null);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is, String contentType) throws IOException {
        ServletResponseUtil.sendFile(response, fileName, is, 0, contentType);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is, int contentLength, String contentType) throws IOException {
        ServletResponseUtil.setHeaders(response, fileName, contentType);
        ServletResponseUtil.write(response, is, contentLength);
    }

    public static void write(HttpServletResponse response, String s) throws IOException {
        ServletResponseUtil.write(response, s.getBytes("UTF-8"));
    }

    public static void write(HttpServletResponse response, byte[] bytes) throws IOException {
        ServletResponseUtil.write(response, bytes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, byte[] bytes, int contentLength) throws IOException {
        block9: {
            BufferedOutputStream os = null;
            try {
                if (!response.isCommitted()) {
                    if (contentLength == 0) {
                        contentLength = bytes.length;
                    }
                    response.setContentLength(contentLength);
                    os = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    ((OutputStream)os).write(bytes, 0, contentLength);
                }
            }
            catch (IOException ioe) {
                if (ioe instanceof SocketException || ioe.getClass().getName().equals(_CLIENT_ABORT_EXCEPTION)) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)ioe);
                    }
                    break block9;
                }
                throw ioe;
            }
            finally {
                ServletResponseUtil.cleanUp(os);
            }
        }
    }

    public static void write(HttpServletResponse response, InputStream is) throws IOException {
        ServletResponseUtil.write(response, is, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, InputStream is, int contentLength) throws IOException {
        BufferedOutputStream os = null;
        try {
            if (!response.isCommitted()) {
                if (contentLength > 0) {
                    response.setContentLength(contentLength);
                }
                os = new BufferedOutputStream((OutputStream)response.getOutputStream());
                int c = is.read();
                while (c != -1) {
                    ((OutputStream)os).write(c);
                    c = is.read();
                }
            }
        }
        finally {
            ServletResponseUtil.cleanUp(os, is);
        }
    }

    protected static void setHeaders(HttpServletResponse response, String fileName, String contentType) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending file of type " + contentType));
        }
        if (Validator.isNotNull((String)contentType)) {
            response.setContentType(contentType);
        }
        response.setHeader("Cache-Control", "public");
        response.setHeader("Pragma", "public");
        if (Validator.isNotNull((String)fileName)) {
            String contentDisposition;
            block10: {
                contentDisposition = "attachment; filename=\"" + fileName + "\"";
                boolean ascii = true;
                for (int i = 0; i < fileName.length(); ++i) {
                    if (CharUtils.isAscii((char)fileName.charAt(i))) continue;
                    ascii = false;
                    break;
                }
                try {
                    if (!ascii) {
                        URLCodec codec = new URLCodec("UTF-8");
                        String encodedFileName = StringUtil.replace((String)codec.encode(fileName), (String)"+", (String)"%20");
                        contentDisposition = "attachment; filename*=UTF-8''" + encodedFileName;
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn((Throwable)e);
                }
            }
            String extension = GetterUtil.getString((String)FileUtil.getExtension((String)fileName)).toLowerCase();
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray((String)"mime.types.content.disposition.inline");
            }
            catch (Exception e) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            if (ArrayUtil.contains((Object[])mimeTypesContentDispositionInline, (Object)extension)) {
                contentDisposition = StringUtil.replace((String)contentDisposition, (String)"attachment; ", (String)"inline; ");
            }
            response.setHeader("Content-Disposition", contentDisposition);
        }
    }
}

