/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.portlet.ResourceResponse;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.CharUtils;

public class PortletResponseUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletResponseUtil.class);

    public static void sendFile(ResourceResponse resourceResponse, String fileName, byte[] bytes) throws IOException {
        PortletResponseUtil.sendFile(resourceResponse, fileName, bytes, null);
    }

    public static void sendFile(ResourceResponse resourceResponse, String fileName, byte[] bytes, String contentType) throws IOException {
        PortletResponseUtil.setHeaders(resourceResponse, fileName, contentType);
        PortletResponseUtil.write(resourceResponse, bytes);
    }

    public static void sendFile(ResourceResponse resourceResponse, String fileName, InputStream is) throws IOException {
        PortletResponseUtil.sendFile(resourceResponse, fileName, is, null);
    }

    public static void sendFile(ResourceResponse resourceResponse, String fileName, InputStream is, String contentType) throws IOException {
        PortletResponseUtil.sendFile(resourceResponse, fileName, is, 0, contentType);
    }

    public static void sendFile(ResourceResponse resourceResponse, String fileName, InputStream is, int contentLength, String contentType) throws IOException {
        PortletResponseUtil.setHeaders(resourceResponse, fileName, contentType);
        PortletResponseUtil.write(resourceResponse, is, contentLength);
    }

    public static void write(ResourceResponse resourceResponse, String s) throws IOException {
        PortletResponseUtil.write(resourceResponse, s.getBytes("UTF-8"));
    }

    public static void write(ResourceResponse resourceResponse, byte[] bytes) throws IOException {
        PortletResponseUtil.write(resourceResponse, bytes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ResourceResponse resourceResponse, byte[] bytes, int contentLength) throws IOException {
        BufferedOutputStream os = null;
        try {
            if (!resourceResponse.isCommitted()) {
                if (contentLength == 0) {
                    contentLength = bytes.length;
                }
                resourceResponse.setContentLength(contentLength);
                os = new BufferedOutputStream(resourceResponse.getPortletOutputStream());
                ((OutputStream)os).write(bytes, 0, contentLength);
            }
        }
        finally {
            ServletResponseUtil.cleanUp(os);
        }
    }

    public static void write(ResourceResponse resourceResponse, InputStream is) throws IOException {
        PortletResponseUtil.write(resourceResponse, is, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ResourceResponse resourceResponse, InputStream is, int contentLength) throws IOException {
        BufferedOutputStream os = null;
        try {
            if (!resourceResponse.isCommitted()) {
                if (contentLength > 0) {
                    resourceResponse.setContentLength(contentLength);
                }
                os = new BufferedOutputStream(resourceResponse.getPortletOutputStream());
                int c = is.read();
                while (c != -1) {
                    ((OutputStream)os).write(c);
                    c = is.read();
                }
            }
        }
        finally {
            ServletResponseUtil.cleanUp(os, is);
        }
    }

    protected static void setHeaders(ResourceResponse resourceResponse, String fileName, String contentType) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending file of type " + contentType));
        }
        if (Validator.isNotNull((String)contentType)) {
            resourceResponse.setContentType(contentType);
        }
        resourceResponse.setProperty("Cache-Control", "public");
        resourceResponse.setProperty("Pragma", "public");
        if (Validator.isNotNull((String)fileName)) {
            String contentDisposition;
            block10: {
                contentDisposition = "attachment; filename=\"" + fileName + "\"";
                boolean ascii = true;
                for (int i = 0; i < fileName.length(); ++i) {
                    if (CharUtils.isAscii((char)fileName.charAt(i))) continue;
                    ascii = false;
                    break;
                }
                try {
                    if (!ascii) {
                        URLCodec codec = new URLCodec("UTF-8");
                        String encodedFileName = StringUtil.replace((String)codec.encode(fileName), (String)"+", (String)"%20");
                        contentDisposition = "attachment; filename*=UTF-8''" + encodedFileName;
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn((Throwable)e);
                }
            }
            String extension = GetterUtil.getString((String)FileUtil.getExtension((String)fileName)).toLowerCase();
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray((String)"mime.types.content.disposition.inline");
            }
            catch (Exception e) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            if (ArrayUtil.contains((Object[])mimeTypesContentDispositionInline, (Object)extension)) {
                contentDisposition = StringUtil.replace((String)contentDisposition, (String)"attachment; ", (String)"inline; ");
            }
            resourceResponse.setProperty("Content-Disposition", contentDisposition);
        }
    }
}

