/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicServletRequest
extends HttpServletRequestWrapper {
    private Map<String, String[]> _params = new HashMap<String, String[]>();
    private boolean _inherit;

    public DynamicServletRequest(HttpServletRequest request) {
        this(request, new HashMap<String, String[]>(), true);
    }

    public DynamicServletRequest(HttpServletRequest request, Map<String, String[]> params) {
        this(request, params, true);
    }

    public DynamicServletRequest(HttpServletRequest request, boolean inherit) {
        this(request, new HashMap<String, String[]>(), inherit);
    }

    public DynamicServletRequest(HttpServletRequest request, Map<String, String[]> params, boolean inherit) {
        super(request);
        this._inherit = inherit;
        if (params != null) {
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                this._params.put(entry.getKey(), entry.getValue());
            }
        }
        if (this._inherit && request instanceof DynamicServletRequest) {
            DynamicServletRequest dynamicRequest = (DynamicServletRequest)request;
            this.setRequest(dynamicRequest.getRequest());
            params = dynamicRequest.getDynamicParameterMap();
            if (params != null) {
                for (Map.Entry<String, String[]> entry : params.entrySet()) {
                    String name = entry.getKey();
                    String[] oldValues = entry.getValue();
                    String[] curValues = this._params.get(name);
                    if (curValues == null) {
                        this._params.put(name, oldValues);
                        continue;
                    }
                    String[] newValues = ArrayUtil.append((String[])oldValues, (String[])curValues);
                    this._params.put(name, newValues);
                }
            }
        }
    }

    public String getParameter(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameter(name);
        }
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String s = enu.nextElement();
            map.put(s, this.getParameterValues(s));
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        ArrayList names = new ArrayList();
        if (this._inherit) {
            Enumeration enu = super.getParameterNames();
            while (enu.hasMoreElements()) {
                names.add(enu.nextElement());
            }
        }
        for (String s : this._params.keySet()) {
            if (names.contains(s)) continue;
            names.add(s);
        }
        return Collections.enumeration(names);
    }

    public String[] getParameterValues(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameterValues(name);
        }
        return values;
    }

    public void setParameter(String name, String value) {
        this._params.put(name, new String[]{value});
    }

    public void setParameterValues(String name, String[] values) {
        this._params.put(name, values);
    }

    public Map<String, String[]> getDynamicParameterMap() {
        return this._params;
    }
}

