/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.util.xml.DocUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import javax.portlet.WindowStateException;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletRequestUtil.class);

    public static List<DiskFileItem> testMultipartWithCommonsFileUpload(ActionRequest actionRequest) throws Exception {
        boolean multiPartContent = PortletFileUpload.isMultipartContent((ActionRequest)actionRequest);
        if (multiPartContent) {
            _log.info((Object)"The given request is a multipart request");
        } else {
            _log.info((Object)"The given request is NOT a multipart request");
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        PortletFileUpload upload = new PortletFileUpload((FileItemFactory)factory);
        List fileItems = upload.parseRequest(actionRequest);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Apache commons upload was able to parse " + fileItems.size() + " items"));
        }
        for (int i = 0; i < fileItems.size(); ++i) {
            DiskFileItem fileItem = (DiskFileItem)fileItems.get(i);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Item " + i + " " + fileItem));
        }
        return fileItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int testMultipartWithPortletInputStream(ActionRequest actionRequest) throws Exception {
        InputStream is = actionRequest.getPortletInputStream();
        if (is != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int c = -1;
            try {
                while ((c = is.read()) != -1) {
                    baos.write(c);
                }
            }
            finally {
                is.close();
            }
            byte[] bytes = baos.toByteArray();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Byte array size from the raw input stream is " + bytes.length));
            }
            return bytes.length;
        }
        return -1;
    }

    public static String toXML(PortletRequest portletRequest, PortletResponse portletResponse) {
        Document doc;
        String xml;
        block16: {
            ThemeDisplay themeDisplay;
            xml = null;
            doc = SAXReaderUtil.createDocument();
            Element reqEl = doc.addElement("request");
            DocUtil.add(reqEl, "container-type", "portlet");
            DocUtil.add(reqEl, "container-namespace", portletRequest.getContextPath());
            DocUtil.add(reqEl, "content-type", portletRequest.getResponseContentType());
            DocUtil.add(reqEl, "server-name", portletRequest.getServerName());
            DocUtil.add(reqEl, "server-port", portletRequest.getServerPort());
            DocUtil.add(reqEl, "secure", portletRequest.isSecure());
            DocUtil.add(reqEl, "auth-type", portletRequest.getAuthType());
            DocUtil.add(reqEl, "remote-user", portletRequest.getRemoteUser());
            DocUtil.add(reqEl, "context-path", portletRequest.getContextPath());
            DocUtil.add(reqEl, "locale", (Object)portletRequest.getLocale());
            DocUtil.add(reqEl, "portlet-mode", (Object)portletRequest.getPortletMode());
            DocUtil.add(reqEl, "portlet-session-id", portletRequest.getRequestedSessionId());
            DocUtil.add(reqEl, "scheme", portletRequest.getScheme());
            DocUtil.add(reqEl, "window-state", (Object)portletRequest.getWindowState());
            if (portletRequest instanceof ActionRequest) {
                DocUtil.add(reqEl, "lifecycle", "ACTION_PHASE");
            } else if (portletRequest instanceof RenderRequest) {
                DocUtil.add(reqEl, "lifecycle", "RENDER_PHASE");
            } else if (portletRequest instanceof ResourceRequest) {
                DocUtil.add(reqEl, "lifecycle", "RESOURCE_PHASE");
            }
            if (portletResponse instanceof MimeResponse) {
                PortletRequestUtil._mimeResponseToXML((MimeResponse)portletResponse, reqEl);
            }
            if ((themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY")) != null) {
                Element themeDisplayEl = reqEl.addElement("theme-display");
                PortletRequestUtil._themeDisplayToXML(themeDisplay, themeDisplayEl);
            }
            Element parametersEl = reqEl.addElement("parameters");
            Enumeration enu = portletRequest.getParameterNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                Element parameterEl = parametersEl.addElement("parameter");
                DocUtil.add(parameterEl, "name", name);
                String[] values = portletRequest.getParameterValues(name);
                for (int i = 0; i < values.length; ++i) {
                    DocUtil.add(parameterEl, "value", values[i]);
                }
            }
            Element attributesEl = reqEl.addElement("attributes");
            enu = portletRequest.getAttributeNames();
            while (enu.hasMoreElements()) {
                Object value;
                String name = (String)enu.nextElement();
                if (!PortletRequestUtil._isValidAttributeName(name) || !PortletRequestUtil._isValidAttributeValue(value = portletRequest.getAttribute(name))) continue;
                Element attributeEl = attributesEl.addElement("attribute");
                DocUtil.add(attributeEl, "name", name);
                DocUtil.add(attributeEl, "value", String.valueOf(value));
            }
            Element portletSessionEl = reqEl.addElement("portlet-session");
            attributesEl = portletSessionEl.addElement("portlet-attributes");
            PortletSession portletSession = portletRequest.getPortletSession();
            try {
                Element attributeEl;
                Object value;
                enu = portletSession.getAttributeNames(2);
                while (enu.hasMoreElements()) {
                    String name = (String)enu.nextElement();
                    if (!PortletRequestUtil._isValidAttributeName(name) || !PortletRequestUtil._isValidAttributeValue(value = portletSession.getAttribute(name, 2))) continue;
                    attributeEl = attributesEl.addElement("attribute");
                    DocUtil.add(attributeEl, "name", name);
                    DocUtil.add(attributeEl, "value", String.valueOf(value));
                }
                attributesEl = portletSessionEl.addElement("application-attributes");
                enu = portletSession.getAttributeNames(1);
                while (enu.hasMoreElements()) {
                    String name = (String)enu.nextElement();
                    if (!PortletRequestUtil._isValidAttributeName(name) || !PortletRequestUtil._isValidAttributeValue(value = portletSession.getAttribute(name, 1))) continue;
                    attributeEl = attributesEl.addElement("attribute");
                    DocUtil.add(attributeEl, "name", name);
                    DocUtil.add(attributeEl, "value", String.valueOf(value));
                }
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block16;
                _log.warn((Object)ise.getMessage());
            }
        }
        try {
            xml = doc.formattedString();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return xml;
    }

    private static void _mimeResponseToXML(MimeResponse mimeResponse, Element reqEl) {
        String namespace;
        block15: {
            block14: {
                namespace = mimeResponse.getNamespace();
                DocUtil.add(reqEl, "portlet-namespace", namespace);
                try {
                    PortletURL actionUrl = mimeResponse.createActionURL();
                    DocUtil.add(reqEl, "action-url", (Object)actionUrl);
                }
                catch (IllegalStateException ise) {
                    if (!_log.isWarnEnabled()) break block14;
                    _log.warn((Object)ise.getMessage());
                }
            }
            try {
                PortletURL renderUrl = mimeResponse.createRenderURL();
                DocUtil.add(reqEl, "render-url", (Object)renderUrl);
                try {
                    renderUrl.setWindowState(LiferayWindowState.EXCLUSIVE);
                    DocUtil.add(reqEl, "render-url-exclusive", (Object)renderUrl);
                }
                catch (WindowStateException wse) {
                    // empty catch block
                }
                try {
                    renderUrl.setWindowState(LiferayWindowState.MAXIMIZED);
                    DocUtil.add(reqEl, "render-url-maximized", (Object)renderUrl);
                }
                catch (WindowStateException wse) {
                    // empty catch block
                }
                try {
                    renderUrl.setWindowState(LiferayWindowState.MINIMIZED);
                    DocUtil.add(reqEl, "render-url-minimized", (Object)renderUrl);
                }
                catch (WindowStateException wse) {
                    // empty catch block
                }
                try {
                    renderUrl.setWindowState(LiferayWindowState.NORMAL);
                    DocUtil.add(reqEl, "render-url-normal", (Object)renderUrl);
                }
                catch (WindowStateException wse) {
                    // empty catch block
                }
                try {
                    renderUrl.setWindowState(LiferayWindowState.POP_UP);
                    DocUtil.add(reqEl, "render-url-pop-up", (Object)renderUrl);
                }
                catch (WindowStateException wse) {}
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block15;
                _log.warn((Object)ise.getMessage());
            }
        }
        ResourceURL resourceURL = mimeResponse.createResourceURL();
        String resourceURLString = HttpUtil.removeParameter((String)resourceURL.toString(), (String)(namespace + "struts_action"));
        resourceURLString = HttpUtil.removeParameter((String)resourceURLString, (String)(namespace + "redirect"));
        DocUtil.add(reqEl, "resource-url", resourceURLString);
    }

    private static void _themeDisplayToXML(ThemeDisplay themeDisplay, Element themeDisplayEl) {
        DocUtil.add(themeDisplayEl, "cdn-host", themeDisplay.getCDNHost());
        DocUtil.add(themeDisplayEl, "company-id", themeDisplay.getCompanyId());
        DocUtil.add(themeDisplayEl, "do-as-user-id", themeDisplay.getDoAsUserId());
        DocUtil.add(themeDisplayEl, "i18n-language-id", themeDisplay.getI18nLanguageId());
        DocUtil.add(themeDisplayEl, "language-id", themeDisplay.getLanguageId());
        DocUtil.add(themeDisplayEl, "locale", (Object)themeDisplay.getLocale());
        DocUtil.add(themeDisplayEl, "path-context", themeDisplay.getPathContext());
        DocUtil.add(themeDisplayEl, "path-friendly-url-private-group", themeDisplay.getPathFriendlyURLPrivateGroup());
        DocUtil.add(themeDisplayEl, "path-friendly-url-private-user", themeDisplay.getPathFriendlyURLPrivateUser());
        DocUtil.add(themeDisplayEl, "path-friendly-url-public", themeDisplay.getPathFriendlyURLPublic());
        DocUtil.add(themeDisplayEl, "path-image", themeDisplay.getPathImage());
        DocUtil.add(themeDisplayEl, "path-main", themeDisplay.getPathMain());
        DocUtil.add(themeDisplayEl, "path-theme-images", themeDisplay.getPathThemeImages());
        DocUtil.add(themeDisplayEl, "plid", themeDisplay.getPlid());
        DocUtil.add(themeDisplayEl, "portal-url", HttpUtil.removeProtocol((String)themeDisplay.getPortalURL()));
        DocUtil.add(themeDisplayEl, "real-user-id", themeDisplay.getRealUserId());
        DocUtil.add(themeDisplayEl, "scope-group-id", themeDisplay.getScopeGroupId());
        DocUtil.add(themeDisplayEl, "secure", themeDisplay.isSecure());
        DocUtil.add(themeDisplayEl, "server-name", themeDisplay.getServerName());
        DocUtil.add(themeDisplayEl, "server-port", themeDisplay.getServerPort());
        DocUtil.add(themeDisplayEl, "time-zone", themeDisplay.getTimeZone().getID());
        DocUtil.add(themeDisplayEl, "url-portal", HttpUtil.removeProtocol((String)themeDisplay.getURLPortal()));
        DocUtil.add(themeDisplayEl, "user-id", themeDisplay.getUserId());
        if (themeDisplay.getPortletDisplay() != null) {
            Element portletDisplayEl = themeDisplayEl.addElement("portlet-display");
            PortletRequestUtil._portletDisplayToXML(themeDisplay.getPortletDisplay(), portletDisplayEl);
        }
    }

    private static boolean _isValidAttributeName(String name) {
        return !name.equalsIgnoreCase("j_password") && !name.equalsIgnoreCase("LAYOUT_CONTENT") && !name.equalsIgnoreCase("LAYOUTS") && !name.equalsIgnoreCase("PORTLET_RENDER_PARAMETERS") && !name.equalsIgnoreCase("USER_PASSWORD") && !name.startsWith("javax.") && !name.startsWith("liferay-ui:");
    }

    private static boolean _isValidAttributeValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            return col.size() != 0;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.size() != 0;
        }
        String objString = String.valueOf(obj);
        if (Validator.isNull((String)objString)) {
            return false;
        }
        String hashCode = "@" + Integer.toHexString(obj.hashCode());
        return !objString.endsWith(hashCode);
    }

    private static void _portletDisplayToXML(PortletDisplay portletDisplay, Element portletDisplayEl) {
        DocUtil.add(portletDisplayEl, "id", portletDisplay.getId());
        DocUtil.add(portletDisplayEl, "instance-id", portletDisplay.getInstanceId());
        DocUtil.add(portletDisplayEl, "portlet-name", portletDisplay.getPortletName());
        DocUtil.add(portletDisplayEl, "resource-pk", portletDisplay.getResourcePK());
        DocUtil.add(portletDisplayEl, "root-portlet-id", portletDisplay.getRootPortletId());
        DocUtil.add(portletDisplayEl, "title", portletDisplay.getTitle());
    }
}

