/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.poi;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XLSTextStripper {
    private static Log _log = LogFactoryUtil.getLog(XLSTextStripper.class);
    private String _text;

    public XLSTextStripper(InputStream is) {
        try {
            StringBuilder sb = new StringBuilder();
            HSSFWorkbook workbook = new HSSFWorkbook(is);
            int numOfSheets = workbook.getNumberOfSheets();
            for (int i = 0; i < numOfSheets; ++i) {
                HSSFSheet sheet = workbook.getSheetAt(i);
                Iterator rowIterator = sheet.rowIterator();
                while (rowIterator.hasNext()) {
                    HSSFRow row = (HSSFRow)rowIterator.next();
                    Iterator cellIterator = row.cellIterator();
                    while (cellIterator.hasNext()) {
                        HSSFCell cell = (HSSFCell)cellIterator.next();
                        String cellStringValue = null;
                        if (cell.getCellType() == 4) {
                            boolean booleanValue = cell.getBooleanCellValue();
                            cellStringValue = String.valueOf(booleanValue);
                        } else if (cell.getCellType() == 0) {
                            double doubleValue = cell.getNumericCellValue();
                            cellStringValue = String.valueOf(doubleValue);
                        } else if (cell.getCellType() == 1) {
                            cellStringValue = cell.getRichStringCellValue().getString();
                        }
                        if (cellStringValue == null) continue;
                        sb.append(cellStringValue);
                        sb.append("\t");
                    }
                    sb.append("\n");
                }
            }
            this._text = sb.toString();
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage());
        }
    }

    public String getText() {
        return this._text;
    }
}

