/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.dao.orm;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CustomSQL {
    public static final String DB2_FUNCTION_IS_NULL = "CAST(? AS VARCHAR(32672)) IS NULL";
    public static final String DB2_FUNCTION_IS_NOT_NULL = "CAST(? AS VARCHAR(32672)) IS NOT NULL";
    public static final String INFORMIX_FUNCTION_IS_NULL = "lportal.isnull(?)";
    public static final String INFORMIX_FUNCTION_IS_NOT_NULL = "NOT lportal.isnull(?)";
    public static final String MYSQL_FUNCTION_IS_NULL = "IFNULL(?, '1') = '1'";
    public static final String MYSQL_FUNCTION_IS_NOT_NULL = "IFNULL(?, '1') = '0'";
    public static final String SYBASE_FUNCTION_IS_NULL = "ISNULL(?, '1') = '1'";
    public static final String SYBASE_FUNCTION_IS_NOT_NULL = "ISNULL(?, '1') = '0'";
    private static Log _log = LogFactoryUtil.getLog(CustomSQL.class);
    private boolean _vendorDB2;
    private boolean _vendorInformix;
    private boolean _vendorMySQL;
    private boolean _vendorOracle;
    private boolean _vendorPostgreSQL;
    private boolean _vendorSybase;
    private String _functionIsNull;
    private String _functionIsNotNull;
    private Map<String, String> _sqlPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomSQL() throws SQLException {
        Connection con = DataAccess.getConnection();
        String functionIsNull = PortalUtil.getCustomSQLFunctionIsNull();
        String functionIsNotNull = PortalUtil.getCustomSQLFunctionIsNotNull();
        try {
            if (Validator.isNotNull((String)functionIsNull) && Validator.isNotNull((String)functionIsNotNull)) {
                this._functionIsNull = functionIsNull;
                this._functionIsNotNull = functionIsNotNull;
                if (_log.isDebugEnabled()) {
                    _log.info((Object)("functionIsNull is manually set to " + functionIsNull));
                    _log.info((Object)("functionIsNotNull is manually set to " + functionIsNotNull));
                }
            } else if (con != null) {
                DatabaseMetaData metaData = con.getMetaData();
                String dbName = GetterUtil.getString((String)metaData.getDatabaseProductName());
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Database name " + dbName));
                }
                if (dbName.startsWith("DB2")) {
                    this._vendorDB2 = true;
                    this._functionIsNull = DB2_FUNCTION_IS_NULL;
                    this._functionIsNotNull = DB2_FUNCTION_IS_NOT_NULL;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected DB2 with database name " + dbName));
                    }
                } else if (dbName.startsWith("Informix")) {
                    this._vendorInformix = true;
                    this._functionIsNull = INFORMIX_FUNCTION_IS_NULL;
                    this._functionIsNotNull = INFORMIX_FUNCTION_IS_NOT_NULL;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected Informix with database name " + dbName));
                    }
                } else if (dbName.startsWith("MySQL")) {
                    this._vendorMySQL = true;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected MySQL with database name " + dbName));
                    }
                } else if (dbName.startsWith("Sybase") || dbName.equals("ASE")) {
                    this._vendorSybase = true;
                    this._functionIsNull = SYBASE_FUNCTION_IS_NULL;
                    this._functionIsNotNull = SYBASE_FUNCTION_IS_NOT_NULL;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected Sybase with database name " + dbName));
                    }
                } else if (dbName.startsWith("Oracle")) {
                    this._vendorOracle = true;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected Oracle with database name " + dbName));
                    }
                } else if (dbName.startsWith("PostgreSQL")) {
                    this._vendorPostgreSQL = true;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected PostgreSQL with database name " + dbName));
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to detect database with name " + dbName));
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
        this._sqlPool = new HashMap<String, String>();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String[] configs = this.getConfigs();
            for (int i = 0; i < configs.length; ++i) {
                this.read(classLoader, configs[i]);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public String get(String id) {
        return this._sqlPool.get(id);
    }

    public boolean isVendorDB2() {
        return this._vendorDB2;
    }

    public boolean isVendorInformix() {
        return this._vendorInformix;
    }

    public boolean isVendorMySQL() {
        return this._vendorMySQL;
    }

    public boolean isVendorOracle() {
        return this._vendorOracle;
    }

    public boolean isVendorPostgreSQL() {
        return this._vendorPostgreSQL;
    }

    public boolean isVendorSybase() {
        return this._vendorSybase;
    }

    public String[] keywords(String keywords) {
        return this.keywords(keywords, true);
    }

    public String[] keywords(String keywords, boolean lowerCase) {
        if (lowerCase) {
            keywords = keywords.toLowerCase();
        }
        keywords = keywords.trim();
        String[] keywordsArray = StringUtil.split((String)keywords, (String)" ");
        for (int i = 0; i < keywordsArray.length; ++i) {
            String keyword = keywordsArray[i];
            keywordsArray[i] = "%" + keyword + "%";
        }
        return keywordsArray;
    }

    public String[] keywords(String[] keywordsArray) {
        return this.keywords(keywordsArray, true);
    }

    public String[] keywords(String[] keywordsArray, boolean lowerCase) {
        if (keywordsArray == null || keywordsArray.length == 0) {
            keywordsArray = new String[]{null};
        }
        if (lowerCase) {
            for (int i = 0; i < keywordsArray.length; ++i) {
                keywordsArray[i] = StringUtil.lowerCase((String)keywordsArray[i]);
            }
        }
        return keywordsArray;
    }

    public String replaceAndOperator(String sql, boolean andOperator) {
        String andOrConnector = "OR";
        String andOrNullCheck = "AND ? IS NOT NULL";
        if (andOperator) {
            andOrConnector = "AND";
            andOrNullCheck = "OR ? IS NULL";
        }
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$AND_OR_CONNECTOR$]", "[$AND_OR_NULL_CHECK$]"}, (String[])new String[]{andOrConnector, andOrNullCheck});
        if (this._vendorPostgreSQL) {
            sql = StringUtil.replace((String)sql, (String[])new String[]{"Date >= ? AND ? IS NOT NULL", "Date <= ? AND ? IS NOT NULL", "Date >= ? OR ? IS NULL", "Date <= ? OR ? IS NULL"}, (String[])new String[]{"Date >= ? AND CAST(? AS TIMESTAMP) IS NOT NULL", "Date <= ? AND CAST(? AS TIMESTAMP) IS NOT NULL", "Date >= ? OR CAST(? AS TIMESTAMP) IS NULL", "Date <= ? OR CAST(? AS TIMESTAMP) IS NULL"});
        }
        sql = this.replaceIsNull(sql);
        return sql;
    }

    public String replaceIsNull(String sql) {
        if (Validator.isNotNull((String)this._functionIsNull)) {
            sql = StringUtil.replace((String)sql, (String[])new String[]{"? IS NULL", "? IS NOT NULL"}, (String[])new String[]{this._functionIsNull, this._functionIsNotNull});
        }
        return sql;
    }

    public String replaceKeywords(String sql, String field, String operator, boolean last, String[] values) {
        if (values.length == 0) {
            return sql;
        }
        StringBuilder oldSql = new StringBuilder();
        oldSql.append("(");
        oldSql.append(field);
        oldSql.append(" ");
        oldSql.append(operator);
        oldSql.append(" ? [$AND_OR_NULL_CHECK$])");
        if (!last) {
            oldSql.append(" [$AND_OR_CONNECTOR$]");
        }
        StringBuilder newSql = new StringBuilder();
        newSql.append("(");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                newSql.append(" OR ");
            }
            newSql.append("(");
            newSql.append(field);
            newSql.append(" ");
            newSql.append(operator);
            newSql.append(" ? [$AND_OR_NULL_CHECK$])");
        }
        newSql.append(")");
        if (!last) {
            newSql.append(" [$AND_OR_CONNECTOR$]");
        }
        return StringUtil.replace((String)sql, (String)oldSql.toString(), (String)newSql.toString());
    }

    public String removeOrderBy(String sql) {
        int pos = sql.indexOf(" ORDER BY ");
        if (pos != -1) {
            sql = sql.substring(0, pos);
        }
        return sql;
    }

    public String replaceOrderBy(String sql, OrderByComparator obc) {
        if (obc == null) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.removeOrderBy(sql));
        sb.append(" ORDER BY ");
        sb.append(obc.getOrderBy());
        return sb.toString();
    }

    protected String[] getConfigs() {
        if (PortalClassLoaderUtil.getClassLoader() == CustomSQL.class.getClassLoader()) {
            Properties propsUtil = PortalUtil.getPortalProperties();
            return StringUtil.split((String)propsUtil.getProperty("custom.sql.configs"));
        }
        return new String[]{"custom-sql/default.xml"};
    }

    protected void read(ClassLoader classLoader, String source) throws Exception {
        String xml = null;
        try {
            xml = StringUtil.read((ClassLoader)classLoader, (String)source);
        }
        catch (Exception e) {
            _log.warn((Object)("Cannot load " + source));
        }
        if (xml == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        Document doc = SAXReaderUtil.read((Reader)new StringReader(xml));
        Element root = doc.getRootElement();
        for (Element sql : root.elements("sql")) {
            String file = sql.attributeValue("file");
            if (Validator.isNotNull((String)file)) {
                this.read(classLoader, file);
                continue;
            }
            String id = sql.attributeValue("id");
            String content = this.transform(sql.getText());
            content = this.replaceIsNull(content);
            this._sqlPool.put(id, content);
        }
    }

    protected String transform(String sql) {
        sql = PortalUtil.transformCustomSQL((String)sql);
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new StringReader(sql));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line.trim());
                sb.append(" ");
            }
            br.close();
        }
        catch (IOException ioe) {
            return sql;
        }
        return sb.toString();
    }
}

