/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;

public class PropertyComparator
implements Comparator {
    private static Log _log = LogFactoryUtil.getLog(PropertyComparator.class);
    private String[] _propertyNames;
    private boolean _asc;
    private boolean _caseSensitive;

    public PropertyComparator(String propertyName) {
        this(new String[]{propertyName}, true, false);
    }

    public PropertyComparator(String[] propertyNames) {
        this(propertyNames, true, false);
    }

    public PropertyComparator(String propertyName, boolean asc, boolean caseSensitive) {
        this(new String[]{propertyName}, asc, caseSensitive);
    }

    public PropertyComparator(String[] propertyNames, boolean asc, boolean caseSensitive) {
        this._propertyNames = propertyNames;
        this._asc = asc;
        this._caseSensitive = caseSensitive;
    }

    public int compare(Object obj1, Object obj2) {
        try {
            for (String propertyName : this._propertyNames) {
                int result;
                Object property1 = PropertyUtils.getProperty((Object)obj1, (String)propertyName);
                Object property2 = PropertyUtils.getProperty((Object)obj2, (String)propertyName);
                if (!this._asc) {
                    Object temp = property1;
                    property1 = property2;
                    property2 = temp;
                }
                if (property1 instanceof String) {
                    int result2 = 0;
                    result2 = this._caseSensitive ? property1.toString().compareTo(property2.toString()) : property1.toString().compareToIgnoreCase(property2.toString());
                    if (result2 != 0) {
                        return result2;
                    }
                }
                if (!(property1 instanceof Comparable) || (result = ((Comparable)property1).compareTo(property2)) == 0) continue;
                return result;
            }
        }
        catch (IllegalAccessException iae) {
            _log.error((Object)iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            _log.error((Object)ite.getMessage());
        }
        catch (NoSuchMethodException nsme) {
            _log.error((Object)nsme.getMessage());
        }
        return -1;
    }
}

