/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.social.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.social.kernel.model.SocialActivityAchievement;
import com.liferay.social.kernel.model.SocialActivityAchievementModel;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SocialActivityAchievement service. Represents a row in the &quot;SocialActivityAchievement&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SocialActivityAchievementModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SocialActivityAchievementImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SocialActivityAchievementImpl
 * @generated
 */
public class SocialActivityAchievementModelImpl
	extends BaseModelImpl<SocialActivityAchievement>
	implements SocialActivityAchievementModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a social activity achievement model instance should use the <code>SocialActivityAchievement</code> interface instead.
	 */
	public static final String TABLE_NAME = "SocialActivityAchievement";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"activityAchievementId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"createDate", Types.BIGINT}, {"name", Types.VARCHAR},
		{"firstInGroup", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("activityAchievementId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("firstInGroup", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SocialActivityAchievement (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,activityAchievementId LONG not null,groupId LONG,companyId LONG,userId LONG,createDate LONG,name VARCHAR(75) null,firstInGroup BOOLEAN,primary key (activityAchievementId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table SocialActivityAchievement";

	public static final String ORDER_BY_JPQL =
		" ORDER BY socialActivityAchievement.activityAchievementId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SocialActivityAchievement.activityAchievementId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FIRSTINGROUP_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVITYACHIEVEMENTID_COLUMN_BITMASK = 16L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.social.kernel.model.SocialActivityAchievement"));

	public SocialActivityAchievementModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _activityAchievementId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setActivityAchievementId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _activityAchievementId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SocialActivityAchievement.class;
	}

	@Override
	public String getModelClassName() {
		return SocialActivityAchievement.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SocialActivityAchievement, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SocialActivityAchievement, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SocialActivityAchievement, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SocialActivityAchievement)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SocialActivityAchievement, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SocialActivityAchievement, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SocialActivityAchievement)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SocialActivityAchievement, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SocialActivityAchievement, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, SocialActivityAchievement>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			SocialActivityAchievement.class.getClassLoader(),
			SocialActivityAchievement.class, ModelWrapper.class);

		try {
			Constructor<SocialActivityAchievement> constructor =
				(Constructor<SocialActivityAchievement>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map
		<String, Function<SocialActivityAchievement, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<SocialActivityAchievement, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<SocialActivityAchievement, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<SocialActivityAchievement, Object>>();
		Map<String, BiConsumer<SocialActivityAchievement, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<SocialActivityAchievement, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", SocialActivityAchievement::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<SocialActivityAchievement, Long>)
				SocialActivityAchievement::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", SocialActivityAchievement::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<SocialActivityAchievement, Long>)
				SocialActivityAchievement::setCtCollectionId);
		attributeGetterFunctions.put(
			"activityAchievementId",
			SocialActivityAchievement::getActivityAchievementId);
		attributeSetterBiConsumers.put(
			"activityAchievementId",
			(BiConsumer<SocialActivityAchievement, Long>)
				SocialActivityAchievement::setActivityAchievementId);
		attributeGetterFunctions.put(
			"groupId", SocialActivityAchievement::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<SocialActivityAchievement, Long>)
				SocialActivityAchievement::setGroupId);
		attributeGetterFunctions.put(
			"companyId", SocialActivityAchievement::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<SocialActivityAchievement, Long>)
				SocialActivityAchievement::setCompanyId);
		attributeGetterFunctions.put(
			"userId", SocialActivityAchievement::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<SocialActivityAchievement, Long>)
				SocialActivityAchievement::setUserId);
		attributeGetterFunctions.put(
			"createDate", SocialActivityAchievement::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<SocialActivityAchievement, Long>)
				SocialActivityAchievement::setCreateDate);
		attributeGetterFunctions.put(
			"name", SocialActivityAchievement::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<SocialActivityAchievement, String>)
				SocialActivityAchievement::setName);
		attributeGetterFunctions.put(
			"firstInGroup", SocialActivityAchievement::getFirstInGroup);
		attributeSetterBiConsumers.put(
			"firstInGroup",
			(BiConsumer<SocialActivityAchievement, Boolean>)
				SocialActivityAchievement::setFirstInGroup);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getActivityAchievementId() {
		return _activityAchievementId;
	}

	@Override
	public void setActivityAchievementId(long activityAchievementId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_activityAchievementId = activityAchievementId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@Override
	public long getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(long createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public boolean getFirstInGroup() {
		return _firstInGroup;
	}

	@Override
	public boolean isFirstInGroup() {
		return _firstInGroup;
	}

	@Override
	public void setFirstInGroup(boolean firstInGroup) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_firstInGroup = firstInGroup;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalFirstInGroup() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("firstInGroup"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SocialActivityAchievement.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public SocialActivityAchievement toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SocialActivityAchievement>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SocialActivityAchievementImpl socialActivityAchievementImpl =
			new SocialActivityAchievementImpl();

		socialActivityAchievementImpl.setMvccVersion(getMvccVersion());
		socialActivityAchievementImpl.setCtCollectionId(getCtCollectionId());
		socialActivityAchievementImpl.setActivityAchievementId(
			getActivityAchievementId());
		socialActivityAchievementImpl.setGroupId(getGroupId());
		socialActivityAchievementImpl.setCompanyId(getCompanyId());
		socialActivityAchievementImpl.setUserId(getUserId());
		socialActivityAchievementImpl.setCreateDate(getCreateDate());
		socialActivityAchievementImpl.setName(getName());
		socialActivityAchievementImpl.setFirstInGroup(isFirstInGroup());

		socialActivityAchievementImpl.resetOriginalValues();

		return socialActivityAchievementImpl;
	}

	@Override
	public SocialActivityAchievement cloneWithOriginalValues() {
		SocialActivityAchievementImpl socialActivityAchievementImpl =
			new SocialActivityAchievementImpl();

		socialActivityAchievementImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		socialActivityAchievementImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		socialActivityAchievementImpl.setActivityAchievementId(
			this.<Long>getColumnOriginalValue("activityAchievementId"));
		socialActivityAchievementImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		socialActivityAchievementImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		socialActivityAchievementImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		socialActivityAchievementImpl.setCreateDate(
			this.<Long>getColumnOriginalValue("createDate"));
		socialActivityAchievementImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		socialActivityAchievementImpl.setFirstInGroup(
			this.<Boolean>getColumnOriginalValue("firstInGroup"));

		return socialActivityAchievementImpl;
	}

	@Override
	public int compareTo(SocialActivityAchievement socialActivityAchievement) {
		long primaryKey = socialActivityAchievement.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SocialActivityAchievement)) {
			return false;
		}

		SocialActivityAchievement socialActivityAchievement =
			(SocialActivityAchievement)object;

		long primaryKey = socialActivityAchievement.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SocialActivityAchievement> toCacheModel() {
		SocialActivityAchievementCacheModel
			socialActivityAchievementCacheModel =
				new SocialActivityAchievementCacheModel();

		socialActivityAchievementCacheModel.mvccVersion = getMvccVersion();

		socialActivityAchievementCacheModel.ctCollectionId =
			getCtCollectionId();

		socialActivityAchievementCacheModel.activityAchievementId =
			getActivityAchievementId();

		socialActivityAchievementCacheModel.groupId = getGroupId();

		socialActivityAchievementCacheModel.companyId = getCompanyId();

		socialActivityAchievementCacheModel.userId = getUserId();

		socialActivityAchievementCacheModel.createDate = getCreateDate();

		socialActivityAchievementCacheModel.name = getName();

		String name = socialActivityAchievementCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			socialActivityAchievementCacheModel.name = null;
		}

		socialActivityAchievementCacheModel.firstInGroup = isFirstInGroup();

		return socialActivityAchievementCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SocialActivityAchievement, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SocialActivityAchievement, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SocialActivityAchievement, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(SocialActivityAchievement)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<SocialActivityAchievement, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<SocialActivityAchievement, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SocialActivityAchievement, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((SocialActivityAchievement)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, SocialActivityAchievement>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _activityAchievementId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private long _createDate;
	private String _name;
	private boolean _firstInGroup;

	public <T> T getColumnValue(String columnName) {
		Function<SocialActivityAchievement, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SocialActivityAchievement)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put(
			"activityAchievementId", _activityAchievementId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("firstInGroup", _firstInGroup);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("activityAchievementId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("name", 128L);

		columnBitmasks.put("firstInGroup", 256L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SocialActivityAchievement _escapedModel;

}