/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.GroupSoap;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the Group service. Represents a row in the &quot;Group_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>GroupModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link GroupImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see GroupImpl
 * @generated
 */
@JSON(strict = true)
public class GroupModelImpl extends BaseModelImpl<Group> implements GroupModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a group model instance should use the <code>Group</code> interface instead.
	 */
	public static final String TABLE_NAME = "Group_";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"creatorUserId", Types.BIGINT},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"parentGroupId", Types.BIGINT}, {"liveGroupId", Types.BIGINT},
		{"treePath", Types.VARCHAR}, {"groupKey", Types.VARCHAR},
		{"name", Types.VARCHAR}, {"description", Types.VARCHAR},
		{"type_", Types.INTEGER}, {"typeSettings", Types.CLOB},
		{"manualMembership", Types.BOOLEAN},
		{"membershipRestriction", Types.INTEGER},
		{"friendlyURL", Types.VARCHAR}, {"site", Types.BOOLEAN},
		{"remoteStagingGroupCount", Types.INTEGER},
		{"inheritContent", Types.BOOLEAN}, {"active_", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("creatorUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentGroupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("liveGroupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("groupKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("typeSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("manualMembership", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("membershipRestriction", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("friendlyURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("site", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("remoteStagingGroupCount", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("inheritContent", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table Group_ (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,groupId LONG not null,companyId LONG,creatorUserId LONG,classNameId LONG,classPK LONG,parentGroupId LONG,liveGroupId LONG,treePath STRING null,groupKey VARCHAR(150) null,name STRING null,description STRING null,type_ INTEGER,typeSettings TEXT null,manualMembership BOOLEAN,membershipRestriction INTEGER,friendlyURL VARCHAR(255) null,site BOOLEAN,remoteStagingGroupCount INTEGER,inheritContent BOOLEAN,active_ BOOLEAN,primary key (groupId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table Group_";

	public static final String ORDER_BY_JPQL = " ORDER BY group_.name ASC";

	public static final String ORDER_BY_SQL = " ORDER BY Group_.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRIENDLYURL_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPKEY_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long INHERITCONTENT_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LIVEGROUPID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTGROUPID_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SITE_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TREEPATH_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 8192L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16384L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static Group toModel(GroupSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		Group model = new GroupImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setCtCollectionId(soapModel.getCtCollectionId());
		model.setUuid(soapModel.getUuid());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setCreatorUserId(soapModel.getCreatorUserId());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setParentGroupId(soapModel.getParentGroupId());
		model.setLiveGroupId(soapModel.getLiveGroupId());
		model.setTreePath(soapModel.getTreePath());
		model.setGroupKey(soapModel.getGroupKey());
		model.setName(soapModel.getName());
		model.setDescription(soapModel.getDescription());
		model.setType(soapModel.getType());
		model.setTypeSettings(soapModel.getTypeSettings());
		model.setManualMembership(soapModel.isManualMembership());
		model.setMembershipRestriction(soapModel.getMembershipRestriction());
		model.setFriendlyURL(soapModel.getFriendlyURL());
		model.setSite(soapModel.isSite());
		model.setRemoteStagingGroupCount(
			soapModel.getRemoteStagingGroupCount());
		model.setInheritContent(soapModel.isInheritContent());
		model.setActive(soapModel.isActive());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<Group> toModels(GroupSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<Group> models = new ArrayList<Group>(soapModels.length);

		for (GroupSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final String MAPPING_TABLE_GROUPS_ORGS_NAME = "Groups_Orgs";

	public static final Object[][] MAPPING_TABLE_GROUPS_ORGS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"organizationId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_GROUPS_ORGS_SQL_CREATE =
		"create table Groups_Orgs (companyId LONG not null,groupId LONG not null,organizationId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (groupId, organizationId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_GROUPS_ORGS = true;

	public static final String MAPPING_TABLE_GROUPS_ROLES_NAME = "Groups_Roles";

	public static final Object[][] MAPPING_TABLE_GROUPS_ROLES_COLUMNS = {
		{"companyId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"roleId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_GROUPS_ROLES_SQL_CREATE =
		"create table Groups_Roles (companyId LONG not null,groupId LONG not null,roleId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (groupId, roleId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_GROUPS_ROLES = true;

	public static final String MAPPING_TABLE_GROUPS_USERGROUPS_NAME =
		"Groups_UserGroups";

	public static final Object[][] MAPPING_TABLE_GROUPS_USERGROUPS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"userGroupId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_GROUPS_USERGROUPS_SQL_CREATE =
		"create table Groups_UserGroups (companyId LONG not null,groupId LONG not null,userGroupId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (groupId, userGroupId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_GROUPS_USERGROUPS = true;

	public static final String MAPPING_TABLE_USERS_GROUPS_NAME = "Users_Groups";

	public static final Object[][] MAPPING_TABLE_USERS_GROUPS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_GROUPS_SQL_CREATE =
		"create table Users_Groups (companyId LONG not null,groupId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (groupId, userId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_USERS_GROUPS = true;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.Group"));

	public GroupModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _groupId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setGroupId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _groupId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return Group.class;
	}

	@Override
	public String getModelClassName() {
		return Group.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<Group, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<Group, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Group, Object> attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((Group)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<Group, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<Group, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept((Group)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<Group, Object>> getAttributeGetterFunctions() {
		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<Group, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, Group>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			Group.class.getClassLoader(), Group.class, ModelWrapper.class);

		try {
			Constructor<Group> constructor =
				(Constructor<Group>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<Group, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<Group, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<Group, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<Group, Object>>();
		Map<String, BiConsumer<Group, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<Group, ?>>();

		attributeGetterFunctions.put("mvccVersion", Group::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion", (BiConsumer<Group, Long>)Group::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", Group::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<Group, Long>)Group::setCtCollectionId);
		attributeGetterFunctions.put("uuid", Group::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<Group, String>)Group::setUuid);
		attributeGetterFunctions.put("groupId", Group::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId", (BiConsumer<Group, Long>)Group::setGroupId);
		attributeGetterFunctions.put("companyId", Group::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<Group, Long>)Group::setCompanyId);
		attributeGetterFunctions.put("creatorUserId", Group::getCreatorUserId);
		attributeSetterBiConsumers.put(
			"creatorUserId", (BiConsumer<Group, Long>)Group::setCreatorUserId);
		attributeGetterFunctions.put("classNameId", Group::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId", (BiConsumer<Group, Long>)Group::setClassNameId);
		attributeGetterFunctions.put("classPK", Group::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK", (BiConsumer<Group, Long>)Group::setClassPK);
		attributeGetterFunctions.put("parentGroupId", Group::getParentGroupId);
		attributeSetterBiConsumers.put(
			"parentGroupId", (BiConsumer<Group, Long>)Group::setParentGroupId);
		attributeGetterFunctions.put("liveGroupId", Group::getLiveGroupId);
		attributeSetterBiConsumers.put(
			"liveGroupId", (BiConsumer<Group, Long>)Group::setLiveGroupId);
		attributeGetterFunctions.put("treePath", Group::getTreePath);
		attributeSetterBiConsumers.put(
			"treePath", (BiConsumer<Group, String>)Group::setTreePath);
		attributeGetterFunctions.put("groupKey", Group::getGroupKey);
		attributeSetterBiConsumers.put(
			"groupKey", (BiConsumer<Group, String>)Group::setGroupKey);
		attributeGetterFunctions.put("name", Group::getName);
		attributeSetterBiConsumers.put(
			"name", (BiConsumer<Group, String>)Group::setName);
		attributeGetterFunctions.put("description", Group::getDescription);
		attributeSetterBiConsumers.put(
			"description", (BiConsumer<Group, String>)Group::setDescription);
		attributeGetterFunctions.put("type", Group::getType);
		attributeSetterBiConsumers.put(
			"type", (BiConsumer<Group, Integer>)Group::setType);
		attributeGetterFunctions.put("typeSettings", Group::getTypeSettings);
		attributeSetterBiConsumers.put(
			"typeSettings", (BiConsumer<Group, String>)Group::setTypeSettings);
		attributeGetterFunctions.put(
			"manualMembership", Group::getManualMembership);
		attributeSetterBiConsumers.put(
			"manualMembership",
			(BiConsumer<Group, Boolean>)Group::setManualMembership);
		attributeGetterFunctions.put(
			"membershipRestriction", Group::getMembershipRestriction);
		attributeSetterBiConsumers.put(
			"membershipRestriction",
			(BiConsumer<Group, Integer>)Group::setMembershipRestriction);
		attributeGetterFunctions.put("friendlyURL", Group::getFriendlyURL);
		attributeSetterBiConsumers.put(
			"friendlyURL", (BiConsumer<Group, String>)Group::setFriendlyURL);
		attributeGetterFunctions.put("site", Group::getSite);
		attributeSetterBiConsumers.put(
			"site", (BiConsumer<Group, Boolean>)Group::setSite);
		attributeGetterFunctions.put(
			"remoteStagingGroupCount", Group::getRemoteStagingGroupCount);
		attributeSetterBiConsumers.put(
			"remoteStagingGroupCount",
			(BiConsumer<Group, Integer>)Group::setRemoteStagingGroupCount);
		attributeGetterFunctions.put(
			"inheritContent", Group::getInheritContent);
		attributeSetterBiConsumers.put(
			"inheritContent",
			(BiConsumer<Group, Boolean>)Group::setInheritContent);
		attributeGetterFunctions.put("active", Group::getActive);
		attributeSetterBiConsumers.put(
			"active", (BiConsumer<Group, Boolean>)Group::setActive);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getCreatorUserId() {
		return _creatorUserId;
	}

	@Override
	public void setCreatorUserId(long creatorUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_creatorUserId = creatorUserId;
	}

	@Override
	public String getCreatorUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getCreatorUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setCreatorUserUuid(String creatorUserUuid) {
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getParentGroupId() {
		return _parentGroupId;
	}

	@Override
	public void setParentGroupId(long parentGroupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentGroupId = parentGroupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentGroupId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentGroupId"));
	}

	@JSON
	@Override
	public long getLiveGroupId() {
		return _liveGroupId;
	}

	@Override
	public void setLiveGroupId(long liveGroupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_liveGroupId = liveGroupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLiveGroupId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("liveGroupId"));
	}

	@JSON
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_treePath = treePath;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalTreePath() {
		return getColumnOriginalValue("treePath");
	}

	@JSON
	@Override
	public String getGroupKey() {
		if (_groupKey == null) {
			return "";
		}
		else {
			return _groupKey;
		}
	}

	@Override
	public void setGroupKey(String groupKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupKey = groupKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalGroupKey() {
		return getColumnOriginalValue("groupKey");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}

	@Override
	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}

	@Override
	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getDescription(), languageId, useDefault);
	}

	@Override
	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}

	@Override
	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@Override
	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setDescription(
		String description, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(
				LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(
				LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}

	@Override
	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getDefault());
	}

	@Override
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale) {

		if (descriptionMap == null) {
			return;
		}

		setDescription(
			LocalizationUtil.updateLocalization(
				descriptionMap, getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	@JSON
	@Override
	public String getTypeSettings() {
		if (_typeSettings == null) {
			return "";
		}
		else {
			return _typeSettings;
		}
	}

	@Override
	public void setTypeSettings(String typeSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typeSettings = typeSettings;
	}

	@JSON
	@Override
	public boolean getManualMembership() {
		return _manualMembership;
	}

	@JSON
	@Override
	public boolean isManualMembership() {
		return _manualMembership;
	}

	@Override
	public void setManualMembership(boolean manualMembership) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_manualMembership = manualMembership;
	}

	@JSON
	@Override
	public int getMembershipRestriction() {
		return _membershipRestriction;
	}

	@Override
	public void setMembershipRestriction(int membershipRestriction) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_membershipRestriction = membershipRestriction;
	}

	@JSON
	@Override
	public String getFriendlyURL() {
		if (_friendlyURL == null) {
			return "";
		}
		else {
			return _friendlyURL;
		}
	}

	@Override
	public void setFriendlyURL(String friendlyURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_friendlyURL = friendlyURL;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFriendlyURL() {
		return getColumnOriginalValue("friendlyURL");
	}

	@JSON
	@Override
	public boolean getSite() {
		return _site;
	}

	@JSON
	@Override
	public boolean isSite() {
		return _site;
	}

	@Override
	public void setSite(boolean site) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_site = site;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalSite() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("site"));
	}

	@JSON
	@Override
	public int getRemoteStagingGroupCount() {
		return _remoteStagingGroupCount;
	}

	@Override
	public void setRemoteStagingGroupCount(int remoteStagingGroupCount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_remoteStagingGroupCount = remoteStagingGroupCount;
	}

	@JSON
	@Override
	public boolean getInheritContent() {
		return _inheritContent;
	}

	@JSON
	@Override
	public boolean isInheritContent() {
		return _inheritContent;
	}

	@Override
	public void setInheritContent(boolean inheritContent) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inheritContent = inheritContent;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalInheritContent() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("inheritContent"));
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), Group.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			Group.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(
				getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(
				getDescription(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public Group toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, Group>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		GroupImpl groupImpl = new GroupImpl();

		groupImpl.setMvccVersion(getMvccVersion());
		groupImpl.setCtCollectionId(getCtCollectionId());
		groupImpl.setUuid(getUuid());
		groupImpl.setGroupId(getGroupId());
		groupImpl.setCompanyId(getCompanyId());
		groupImpl.setCreatorUserId(getCreatorUserId());
		groupImpl.setClassNameId(getClassNameId());
		groupImpl.setClassPK(getClassPK());
		groupImpl.setParentGroupId(getParentGroupId());
		groupImpl.setLiveGroupId(getLiveGroupId());
		groupImpl.setTreePath(getTreePath());
		groupImpl.setGroupKey(getGroupKey());
		groupImpl.setName(getName());
		groupImpl.setDescription(getDescription());
		groupImpl.setType(getType());
		groupImpl.setTypeSettings(getTypeSettings());
		groupImpl.setManualMembership(isManualMembership());
		groupImpl.setMembershipRestriction(getMembershipRestriction());
		groupImpl.setFriendlyURL(getFriendlyURL());
		groupImpl.setSite(isSite());
		groupImpl.setRemoteStagingGroupCount(getRemoteStagingGroupCount());
		groupImpl.setInheritContent(isInheritContent());
		groupImpl.setActive(isActive());

		groupImpl.resetOriginalValues();

		return groupImpl;
	}

	@Override
	public Group cloneWithOriginalValues() {
		GroupImpl groupImpl = new GroupImpl();

		groupImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		groupImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		groupImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		groupImpl.setGroupId(this.<Long>getColumnOriginalValue("groupId"));
		groupImpl.setCompanyId(this.<Long>getColumnOriginalValue("companyId"));
		groupImpl.setCreatorUserId(
			this.<Long>getColumnOriginalValue("creatorUserId"));
		groupImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		groupImpl.setClassPK(this.<Long>getColumnOriginalValue("classPK"));
		groupImpl.setParentGroupId(
			this.<Long>getColumnOriginalValue("parentGroupId"));
		groupImpl.setLiveGroupId(
			this.<Long>getColumnOriginalValue("liveGroupId"));
		groupImpl.setTreePath(this.<String>getColumnOriginalValue("treePath"));
		groupImpl.setGroupKey(this.<String>getColumnOriginalValue("groupKey"));
		groupImpl.setName(this.<String>getColumnOriginalValue("name"));
		groupImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		groupImpl.setType(this.<Integer>getColumnOriginalValue("type_"));
		groupImpl.setTypeSettings(
			this.<String>getColumnOriginalValue("typeSettings"));
		groupImpl.setManualMembership(
			this.<Boolean>getColumnOriginalValue("manualMembership"));
		groupImpl.setMembershipRestriction(
			this.<Integer>getColumnOriginalValue("membershipRestriction"));
		groupImpl.setFriendlyURL(
			this.<String>getColumnOriginalValue("friendlyURL"));
		groupImpl.setSite(this.<Boolean>getColumnOriginalValue("site"));
		groupImpl.setRemoteStagingGroupCount(
			this.<Integer>getColumnOriginalValue("remoteStagingGroupCount"));
		groupImpl.setInheritContent(
			this.<Boolean>getColumnOriginalValue("inheritContent"));
		groupImpl.setActive(this.<Boolean>getColumnOriginalValue("active_"));

		return groupImpl;
	}

	@Override
	public int compareTo(Group group) {
		int value = 0;

		value = getName().compareToIgnoreCase(group.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof Group)) {
			return false;
		}

		Group group = (Group)object;

		long primaryKey = group.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<Group> toCacheModel() {
		GroupCacheModel groupCacheModel = new GroupCacheModel();

		groupCacheModel.mvccVersion = getMvccVersion();

		groupCacheModel.ctCollectionId = getCtCollectionId();

		groupCacheModel.uuid = getUuid();

		String uuid = groupCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			groupCacheModel.uuid = null;
		}

		groupCacheModel.groupId = getGroupId();

		groupCacheModel.companyId = getCompanyId();

		groupCacheModel.creatorUserId = getCreatorUserId();

		groupCacheModel.classNameId = getClassNameId();

		groupCacheModel.classPK = getClassPK();

		groupCacheModel.parentGroupId = getParentGroupId();

		groupCacheModel.liveGroupId = getLiveGroupId();

		groupCacheModel.treePath = getTreePath();

		String treePath = groupCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			groupCacheModel.treePath = null;
		}

		groupCacheModel.groupKey = getGroupKey();

		String groupKey = groupCacheModel.groupKey;

		if ((groupKey != null) && (groupKey.length() == 0)) {
			groupCacheModel.groupKey = null;
		}

		groupCacheModel.name = getName();

		String name = groupCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			groupCacheModel.name = null;
		}

		groupCacheModel.description = getDescription();

		String description = groupCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			groupCacheModel.description = null;
		}

		groupCacheModel.type = getType();

		groupCacheModel.typeSettings = getTypeSettings();

		String typeSettings = groupCacheModel.typeSettings;

		if ((typeSettings != null) && (typeSettings.length() == 0)) {
			groupCacheModel.typeSettings = null;
		}

		groupCacheModel.manualMembership = isManualMembership();

		groupCacheModel.membershipRestriction = getMembershipRestriction();

		groupCacheModel.friendlyURL = getFriendlyURL();

		String friendlyURL = groupCacheModel.friendlyURL;

		if ((friendlyURL != null) && (friendlyURL.length() == 0)) {
			groupCacheModel.friendlyURL = null;
		}

		groupCacheModel.site = isSite();

		groupCacheModel.remoteStagingGroupCount = getRemoteStagingGroupCount();

		groupCacheModel.inheritContent = isInheritContent();

		groupCacheModel.active = isActive();

		return groupCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<Group, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<Group, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Group, Object> attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((Group)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<Group, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<Group, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Group, Object> attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((Group)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, Group>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _groupId;
	private long _companyId;
	private long _creatorUserId;
	private long _classNameId;
	private long _classPK;
	private long _parentGroupId;
	private long _liveGroupId;
	private String _treePath;
	private String _groupKey;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private int _type;
	private String _typeSettings;
	private boolean _manualMembership;
	private int _membershipRestriction;
	private String _friendlyURL;
	private boolean _site;
	private int _remoteStagingGroupCount;
	private boolean _inheritContent;
	private boolean _active;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<Group, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((Group)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("creatorUserId", _creatorUserId);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("parentGroupId", _parentGroupId);
		_columnOriginalValues.put("liveGroupId", _liveGroupId);
		_columnOriginalValues.put("treePath", _treePath);
		_columnOriginalValues.put("groupKey", _groupKey);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("typeSettings", _typeSettings);
		_columnOriginalValues.put("manualMembership", _manualMembership);
		_columnOriginalValues.put(
			"membershipRestriction", _membershipRestriction);
		_columnOriginalValues.put("friendlyURL", _friendlyURL);
		_columnOriginalValues.put("site", _site);
		_columnOriginalValues.put(
			"remoteStagingGroupCount", _remoteStagingGroupCount);
		_columnOriginalValues.put("inheritContent", _inheritContent);
		_columnOriginalValues.put("active_", _active);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");
		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("creatorUserId", 32L);

		columnBitmasks.put("classNameId", 64L);

		columnBitmasks.put("classPK", 128L);

		columnBitmasks.put("parentGroupId", 256L);

		columnBitmasks.put("liveGroupId", 512L);

		columnBitmasks.put("treePath", 1024L);

		columnBitmasks.put("groupKey", 2048L);

		columnBitmasks.put("name", 4096L);

		columnBitmasks.put("description", 8192L);

		columnBitmasks.put("type_", 16384L);

		columnBitmasks.put("typeSettings", 32768L);

		columnBitmasks.put("manualMembership", 65536L);

		columnBitmasks.put("membershipRestriction", 131072L);

		columnBitmasks.put("friendlyURL", 262144L);

		columnBitmasks.put("site", 524288L);

		columnBitmasks.put("remoteStagingGroupCount", 1048576L);

		columnBitmasks.put("inheritContent", 2097152L);

		columnBitmasks.put("active_", 4194304L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private Group _escapedModel;

}