/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

/**
 * @author Brian Wing Shun Chan
 */
public class LayoutSetBranchPermissionUtil {

	public static void check(
			PermissionChecker permissionChecker,
			LayoutSetBranch layoutSetBranch, String actionId)
		throws PortalException {

		_layoutSetBranchPermission.check(
			permissionChecker, layoutSetBranch, actionId);
	}

	public static void check(
			PermissionChecker permissionChecker, long layoutSetBranchId,
			String actionId)
		throws PortalException {

		_layoutSetBranchPermission.check(
			permissionChecker, layoutSetBranchId, actionId);
	}

	public static boolean contains(
		PermissionChecker permissionChecker, LayoutSetBranch layoutSetBranch,
		String actionId) {

		return _layoutSetBranchPermission.contains(
			permissionChecker, layoutSetBranch, actionId);
	}

	public static boolean contains(
			PermissionChecker permissionChecker, long layoutSetBranchId,
			String actionId)
		throws PortalException {

		return _layoutSetBranchPermission.contains(
			permissionChecker, layoutSetBranchId, actionId);
	}

	public static LayoutSetBranchPermission getLayoutSetBranchPermission() {
		return _layoutSetBranchPermission;
	}

	public void setLayoutSetBranchPermission(
		LayoutSetBranchPermission layoutSetBranchPermission) {

		_layoutSetBranchPermission = layoutSetBranchPermission;
	}

	private static LayoutSetBranchPermission _layoutSetBranchPermission;

}