/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.dao.jdbc.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

/**
 * @author Samuel Ziemer
 */
public class StatementWrapper implements Statement {

	public StatementWrapper(Statement statement) {
		_statement = statement;
	}

	@Override
	public void addBatch(String sql) throws SQLException {
		_statement.addBatch(sql);
	}

	@Override
	public void cancel() throws SQLException {
		_statement.cancel();
	}

	@Override
	public void clearBatch() throws SQLException {
		_statement.clearBatch();
	}

	@Override
	public void clearWarnings() throws SQLException {
		_statement.clearWarnings();
	}

	@Override
	public void close() throws SQLException {
		_statement.close();
	}

	@Override
	public void closeOnCompletion() throws SQLException {
		_statement.closeOnCompletion();
	}

	@Override
	public boolean execute(String sql) throws SQLException {
		return _statement.execute(sql);
	}

	@Override
	public boolean execute(String sql, int autoGeneratedKeys)
		throws SQLException {

		return _statement.execute(sql, autoGeneratedKeys);
	}

	@Override
	public boolean execute(String sql, int[] columnIndexes)
		throws SQLException {

		return _statement.execute(sql, columnIndexes);
	}

	@Override
	public boolean execute(String sql, String[] columnNames)
		throws SQLException {

		return _statement.execute(sql, columnNames);
	}

	@Override
	public int[] executeBatch() throws SQLException {
		return _statement.executeBatch();
	}

	@Override
	public ResultSet executeQuery(String sql) throws SQLException {
		return _statement.executeQuery(sql);
	}

	@Override
	public int executeUpdate(String sql) throws SQLException {
		return _statement.executeUpdate(sql);
	}

	@Override
	public int executeUpdate(String sql, int autoGeneratedKeys)
		throws SQLException {

		return _statement.executeUpdate(sql, autoGeneratedKeys);
	}

	@Override
	public int executeUpdate(String sql, int[] columnIndexes)
		throws SQLException {

		return _statement.executeUpdate(sql, columnIndexes);
	}

	@Override
	public int executeUpdate(String sql, String[] columnNames)
		throws SQLException {

		return _statement.executeUpdate(sql, columnNames);
	}

	@Override
	public Connection getConnection() throws SQLException {
		return _statement.getConnection();
	}

	@Override
	public int getFetchDirection() throws SQLException {
		return _statement.getFetchDirection();
	}

	@Override
	public int getFetchSize() throws SQLException {
		return _statement.getFetchSize();
	}

	@Override
	public ResultSet getGeneratedKeys() throws SQLException {
		return _statement.getGeneratedKeys();
	}

	@Override
	public int getMaxFieldSize() throws SQLException {
		return _statement.getMaxFieldSize();
	}

	@Override
	public int getMaxRows() throws SQLException {
		return _statement.getMaxRows();
	}

	@Override
	public boolean getMoreResults() throws SQLException {
		return _statement.getMoreResults();
	}

	@Override
	public boolean getMoreResults(int current) throws SQLException {
		return _statement.getMoreResults(current);
	}

	@Override
	public int getQueryTimeout() throws SQLException {
		return _statement.getQueryTimeout();
	}

	@Override
	public ResultSet getResultSet() throws SQLException {
		return _statement.getResultSet();
	}

	@Override
	public int getResultSetConcurrency() throws SQLException {
		return _statement.getResultSetConcurrency();
	}

	@Override
	public int getResultSetHoldability() throws SQLException {
		return _statement.getResultSetHoldability();
	}

	@Override
	public int getResultSetType() throws SQLException {
		return _statement.getResultSetType();
	}

	@Override
	public int getUpdateCount() throws SQLException {
		return _statement.getUpdateCount();
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		return _statement.getWarnings();
	}

	@Override
	public boolean isClosed() throws SQLException {
		return _statement.isClosed();
	}

	@Override
	public boolean isCloseOnCompletion() throws SQLException {
		return _statement.isCloseOnCompletion();
	}

	@Override
	public boolean isPoolable() throws SQLException {
		return _statement.isPoolable();
	}

	@Override
	public boolean isWrapperFor(Class<?> clazz) throws SQLException {
		return Statement.class.equals(clazz);
	}

	@Override
	public void setCursorName(String name) throws SQLException {
		_statement.setCursorName(name);
	}

	@Override
	public void setEscapeProcessing(boolean enable) throws SQLException {
		_statement.setEscapeProcessing(enable);
	}

	@Override
	public void setFetchDirection(int direction) throws SQLException {
		_statement.setFetchDirection(direction);
	}

	@Override
	public void setFetchSize(int rows) throws SQLException {
		_statement.setFetchSize(rows);
	}

	@Override
	public void setMaxFieldSize(int max) throws SQLException {
		_statement.setMaxFieldSize(max);
	}

	@Override
	public void setMaxRows(int max) throws SQLException {
		_statement.setMaxRows(max);
	}

	@Override
	public void setPoolable(boolean poolable) throws SQLException {
		_statement.setPoolable(poolable);
	}

	@Override
	public void setQueryTimeout(int seconds) throws SQLException {
		_statement.setQueryTimeout(seconds);
	}

	@Override
	public <T> T unwrap(Class<T> clazz) throws SQLException {
		if (!Statement.class.equals(clazz)) {
			throw new SQLException("Invalid class " + clazz);
		}

		return (T)this;
	}

	private volatile Statement _statement;

}