/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.json.storage.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the JSONStorageEntry service. Represents a row in the &quot;JSONStorageEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.json.storage.model.impl.JSONStorageEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.json.storage.model.impl.JSONStorageEntryImpl</code>.
 * </p>
 *
 * @author Preston Crary
 * @see JSONStorageEntry
 * @generated
 */
@ProviderType
public interface JSONStorageEntryModel
	extends AttachedModel, BaseModel<JSONStorageEntry>,
			CTModel<JSONStorageEntry>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a json storage entry model instance should use the {@link JSONStorageEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this json storage entry.
	 *
	 * @return the primary key of this json storage entry
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this json storage entry.
	 *
	 * @param primaryKey the primary key of this json storage entry
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this json storage entry.
	 *
	 * @return the mvcc version of this json storage entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this json storage entry.
	 *
	 * @param mvccVersion the mvcc version of this json storage entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this json storage entry.
	 *
	 * @return the ct collection ID of this json storage entry
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this json storage entry.
	 *
	 * @param ctCollectionId the ct collection ID of this json storage entry
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the json storage entry ID of this json storage entry.
	 *
	 * @return the json storage entry ID of this json storage entry
	 */
	public long getJsonStorageEntryId();

	/**
	 * Sets the json storage entry ID of this json storage entry.
	 *
	 * @param jsonStorageEntryId the json storage entry ID of this json storage entry
	 */
	public void setJsonStorageEntryId(long jsonStorageEntryId);

	/**
	 * Returns the company ID of this json storage entry.
	 *
	 * @return the company ID of this json storage entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this json storage entry.
	 *
	 * @param companyId the company ID of this json storage entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the fully qualified class name of this json storage entry.
	 *
	 * @return the fully qualified class name of this json storage entry
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this json storage entry.
	 *
	 * @return the class name ID of this json storage entry
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this json storage entry.
	 *
	 * @param classNameId the class name ID of this json storage entry
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this json storage entry.
	 *
	 * @return the class pk of this json storage entry
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this json storage entry.
	 *
	 * @param classPK the class pk of this json storage entry
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the parent json storage entry ID of this json storage entry.
	 *
	 * @return the parent json storage entry ID of this json storage entry
	 */
	public long getParentJSONStorageEntryId();

	/**
	 * Sets the parent json storage entry ID of this json storage entry.
	 *
	 * @param parentJSONStorageEntryId the parent json storage entry ID of this json storage entry
	 */
	public void setParentJSONStorageEntryId(long parentJSONStorageEntryId);

	/**
	 * Returns the index of this json storage entry.
	 *
	 * @return the index of this json storage entry
	 */
	public int getIndex();

	/**
	 * Sets the index of this json storage entry.
	 *
	 * @param index the index of this json storage entry
	 */
	public void setIndex(int index);

	/**
	 * Returns the key of this json storage entry.
	 *
	 * @return the key of this json storage entry
	 */
	@AutoEscape
	public String getKey();

	/**
	 * Sets the key of this json storage entry.
	 *
	 * @param key the key of this json storage entry
	 */
	public void setKey(String key);

	/**
	 * Returns the type of this json storage entry.
	 *
	 * @return the type of this json storage entry
	 */
	public int getType();

	/**
	 * Sets the type of this json storage entry.
	 *
	 * @param type the type of this json storage entry
	 */
	public void setType(int type);

	/**
	 * Returns the value long of this json storage entry.
	 *
	 * @return the value long of this json storage entry
	 */
	public long getValueLong();

	/**
	 * Sets the value long of this json storage entry.
	 *
	 * @param valueLong the value long of this json storage entry
	 */
	public void setValueLong(long valueLong);

	/**
	 * Returns the value string of this json storage entry.
	 *
	 * @return the value string of this json storage entry
	 */
	@AutoEscape
	public String getValueString();

	/**
	 * Sets the value string of this json storage entry.
	 *
	 * @param valueString the value string of this json storage entry
	 */
	public void setValueString(String valueString);

	@Override
	public JSONStorageEntry cloneWithOriginalValues();

}