/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.shop.by.diagram.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CSDiagramSetting service. Represents a row in the &quot;CSDiagramSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.shop.by.diagram.model.impl.CSDiagramSettingModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.shop.by.diagram.model.impl.CSDiagramSettingImpl</code>.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CSDiagramSetting
 * @generated
 */
@ProviderType
public interface CSDiagramSettingModel
	extends BaseModel<CSDiagramSetting>, ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cs diagram setting model instance should use the {@link CSDiagramSetting} interface instead.
	 */

	/**
	 * Returns the primary key of this cs diagram setting.
	 *
	 * @return the primary key of this cs diagram setting
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cs diagram setting.
	 *
	 * @param primaryKey the primary key of this cs diagram setting
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this cs diagram setting.
	 *
	 * @return the uuid of this cs diagram setting
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this cs diagram setting.
	 *
	 * @param uuid the uuid of this cs diagram setting
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the cs diagram setting ID of this cs diagram setting.
	 *
	 * @return the cs diagram setting ID of this cs diagram setting
	 */
	public long getCSDiagramSettingId();

	/**
	 * Sets the cs diagram setting ID of this cs diagram setting.
	 *
	 * @param CSDiagramSettingId the cs diagram setting ID of this cs diagram setting
	 */
	public void setCSDiagramSettingId(long CSDiagramSettingId);

	/**
	 * Returns the company ID of this cs diagram setting.
	 *
	 * @return the company ID of this cs diagram setting
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cs diagram setting.
	 *
	 * @param companyId the company ID of this cs diagram setting
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cs diagram setting.
	 *
	 * @return the user ID of this cs diagram setting
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cs diagram setting.
	 *
	 * @param userId the user ID of this cs diagram setting
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cs diagram setting.
	 *
	 * @return the user uuid of this cs diagram setting
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cs diagram setting.
	 *
	 * @param userUuid the user uuid of this cs diagram setting
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cs diagram setting.
	 *
	 * @return the user name of this cs diagram setting
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cs diagram setting.
	 *
	 * @param userName the user name of this cs diagram setting
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cs diagram setting.
	 *
	 * @return the create date of this cs diagram setting
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cs diagram setting.
	 *
	 * @param createDate the create date of this cs diagram setting
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cs diagram setting.
	 *
	 * @return the modified date of this cs diagram setting
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cs diagram setting.
	 *
	 * @param modifiedDate the modified date of this cs diagram setting
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the cp attachment file entry ID of this cs diagram setting.
	 *
	 * @return the cp attachment file entry ID of this cs diagram setting
	 */
	public long getCPAttachmentFileEntryId();

	/**
	 * Sets the cp attachment file entry ID of this cs diagram setting.
	 *
	 * @param CPAttachmentFileEntryId the cp attachment file entry ID of this cs diagram setting
	 */
	public void setCPAttachmentFileEntryId(long CPAttachmentFileEntryId);

	/**
	 * Returns the cp definition ID of this cs diagram setting.
	 *
	 * @return the cp definition ID of this cs diagram setting
	 */
	public long getCPDefinitionId();

	/**
	 * Sets the cp definition ID of this cs diagram setting.
	 *
	 * @param CPDefinitionId the cp definition ID of this cs diagram setting
	 */
	public void setCPDefinitionId(long CPDefinitionId);

	/**
	 * Returns the color of this cs diagram setting.
	 *
	 * @return the color of this cs diagram setting
	 */
	@AutoEscape
	public String getColor();

	/**
	 * Sets the color of this cs diagram setting.
	 *
	 * @param color the color of this cs diagram setting
	 */
	public void setColor(String color);

	/**
	 * Returns the radius of this cs diagram setting.
	 *
	 * @return the radius of this cs diagram setting
	 */
	public double getRadius();

	/**
	 * Sets the radius of this cs diagram setting.
	 *
	 * @param radius the radius of this cs diagram setting
	 */
	public void setRadius(double radius);

	/**
	 * Returns the type of this cs diagram setting.
	 *
	 * @return the type of this cs diagram setting
	 */
	@AutoEscape
	public String getType();

	/**
	 * Sets the type of this cs diagram setting.
	 *
	 * @param type the type of this cs diagram setting
	 */
	public void setType(String type);

	@Override
	public CSDiagramSetting cloneWithOriginalValues();

}