/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.product.type.virtual.order.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommerceVirtualOrderItem service. Represents a row in the &quot;CommerceVirtualOrderItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.product.type.virtual.order.model.impl.CommerceVirtualOrderItemModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.product.type.virtual.order.model.impl.CommerceVirtualOrderItemImpl</code>.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceVirtualOrderItem
 * @generated
 */
@ProviderType
public interface CommerceVirtualOrderItemModel
	extends BaseModel<CommerceVirtualOrderItem>, GroupedModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce virtual order item model instance should use the {@link CommerceVirtualOrderItem} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce virtual order item.
	 *
	 * @return the primary key of this commerce virtual order item
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce virtual order item.
	 *
	 * @param primaryKey the primary key of this commerce virtual order item
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this commerce virtual order item.
	 *
	 * @return the uuid of this commerce virtual order item
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this commerce virtual order item.
	 *
	 * @param uuid the uuid of this commerce virtual order item
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the commerce virtual order item ID of this commerce virtual order item.
	 *
	 * @return the commerce virtual order item ID of this commerce virtual order item
	 */
	public long getCommerceVirtualOrderItemId();

	/**
	 * Sets the commerce virtual order item ID of this commerce virtual order item.
	 *
	 * @param commerceVirtualOrderItemId the commerce virtual order item ID of this commerce virtual order item
	 */
	public void setCommerceVirtualOrderItemId(long commerceVirtualOrderItemId);

	/**
	 * Returns the group ID of this commerce virtual order item.
	 *
	 * @return the group ID of this commerce virtual order item
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this commerce virtual order item.
	 *
	 * @param groupId the group ID of this commerce virtual order item
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this commerce virtual order item.
	 *
	 * @return the company ID of this commerce virtual order item
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce virtual order item.
	 *
	 * @param companyId the company ID of this commerce virtual order item
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce virtual order item.
	 *
	 * @return the user ID of this commerce virtual order item
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce virtual order item.
	 *
	 * @param userId the user ID of this commerce virtual order item
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce virtual order item.
	 *
	 * @return the user uuid of this commerce virtual order item
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce virtual order item.
	 *
	 * @param userUuid the user uuid of this commerce virtual order item
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce virtual order item.
	 *
	 * @return the user name of this commerce virtual order item
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce virtual order item.
	 *
	 * @param userName the user name of this commerce virtual order item
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce virtual order item.
	 *
	 * @return the create date of this commerce virtual order item
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce virtual order item.
	 *
	 * @param createDate the create date of this commerce virtual order item
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce virtual order item.
	 *
	 * @return the modified date of this commerce virtual order item
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce virtual order item.
	 *
	 * @param modifiedDate the modified date of this commerce virtual order item
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce order item ID of this commerce virtual order item.
	 *
	 * @return the commerce order item ID of this commerce virtual order item
	 */
	public long getCommerceOrderItemId();

	/**
	 * Sets the commerce order item ID of this commerce virtual order item.
	 *
	 * @param commerceOrderItemId the commerce order item ID of this commerce virtual order item
	 */
	public void setCommerceOrderItemId(long commerceOrderItemId);

	/**
	 * Returns the file entry ID of this commerce virtual order item.
	 *
	 * @return the file entry ID of this commerce virtual order item
	 */
	public long getFileEntryId();

	/**
	 * Sets the file entry ID of this commerce virtual order item.
	 *
	 * @param fileEntryId the file entry ID of this commerce virtual order item
	 */
	public void setFileEntryId(long fileEntryId);

	/**
	 * Returns the url of this commerce virtual order item.
	 *
	 * @return the url of this commerce virtual order item
	 */
	@AutoEscape
	public String getUrl();

	/**
	 * Sets the url of this commerce virtual order item.
	 *
	 * @param url the url of this commerce virtual order item
	 */
	public void setUrl(String url);

	/**
	 * Returns the activation status of this commerce virtual order item.
	 *
	 * @return the activation status of this commerce virtual order item
	 */
	public int getActivationStatus();

	/**
	 * Sets the activation status of this commerce virtual order item.
	 *
	 * @param activationStatus the activation status of this commerce virtual order item
	 */
	public void setActivationStatus(int activationStatus);

	/**
	 * Returns the duration of this commerce virtual order item.
	 *
	 * @return the duration of this commerce virtual order item
	 */
	public long getDuration();

	/**
	 * Sets the duration of this commerce virtual order item.
	 *
	 * @param duration the duration of this commerce virtual order item
	 */
	public void setDuration(long duration);

	/**
	 * Returns the usages of this commerce virtual order item.
	 *
	 * @return the usages of this commerce virtual order item
	 */
	public int getUsages();

	/**
	 * Sets the usages of this commerce virtual order item.
	 *
	 * @param usages the usages of this commerce virtual order item
	 */
	public void setUsages(int usages);

	/**
	 * Returns the max usages of this commerce virtual order item.
	 *
	 * @return the max usages of this commerce virtual order item
	 */
	public int getMaxUsages();

	/**
	 * Sets the max usages of this commerce virtual order item.
	 *
	 * @param maxUsages the max usages of this commerce virtual order item
	 */
	public void setMaxUsages(int maxUsages);

	/**
	 * Returns the active of this commerce virtual order item.
	 *
	 * @return the active of this commerce virtual order item
	 */
	public boolean getActive();

	/**
	 * Returns <code>true</code> if this commerce virtual order item is active.
	 *
	 * @return <code>true</code> if this commerce virtual order item is active; <code>false</code> otherwise
	 */
	public boolean isActive();

	/**
	 * Sets whether this commerce virtual order item is active.
	 *
	 * @param active the active of this commerce virtual order item
	 */
	public void setActive(boolean active);

	/**
	 * Returns the start date of this commerce virtual order item.
	 *
	 * @return the start date of this commerce virtual order item
	 */
	public Date getStartDate();

	/**
	 * Sets the start date of this commerce virtual order item.
	 *
	 * @param startDate the start date of this commerce virtual order item
	 */
	public void setStartDate(Date startDate);

	/**
	 * Returns the end date of this commerce virtual order item.
	 *
	 * @return the end date of this commerce virtual order item
	 */
	public Date getEndDate();

	/**
	 * Sets the end date of this commerce virtual order item.
	 *
	 * @param endDate the end date of this commerce virtual order item
	 */
	public void setEndDate(Date endDate);

	@Override
	public CommerceVirtualOrderItem cloneWithOriginalValues();

}