/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.product.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CPSpecificationOption service. Represents a row in the &quot;CPSpecificationOption&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.product.model.impl.CPSpecificationOptionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.product.model.impl.CPSpecificationOptionImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see CPSpecificationOption
 * @generated
 */
@ProviderType
public interface CPSpecificationOptionModel
	extends BaseModel<CPSpecificationOption>, LocalizedModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cp specification option model instance should use the {@link CPSpecificationOption} interface instead.
	 */

	/**
	 * Returns the primary key of this cp specification option.
	 *
	 * @return the primary key of this cp specification option
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cp specification option.
	 *
	 * @param primaryKey the primary key of this cp specification option
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this cp specification option.
	 *
	 * @return the uuid of this cp specification option
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this cp specification option.
	 *
	 * @param uuid the uuid of this cp specification option
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the cp specification option ID of this cp specification option.
	 *
	 * @return the cp specification option ID of this cp specification option
	 */
	public long getCPSpecificationOptionId();

	/**
	 * Sets the cp specification option ID of this cp specification option.
	 *
	 * @param CPSpecificationOptionId the cp specification option ID of this cp specification option
	 */
	public void setCPSpecificationOptionId(long CPSpecificationOptionId);

	/**
	 * Returns the company ID of this cp specification option.
	 *
	 * @return the company ID of this cp specification option
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cp specification option.
	 *
	 * @param companyId the company ID of this cp specification option
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cp specification option.
	 *
	 * @return the user ID of this cp specification option
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cp specification option.
	 *
	 * @param userId the user ID of this cp specification option
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cp specification option.
	 *
	 * @return the user uuid of this cp specification option
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cp specification option.
	 *
	 * @param userUuid the user uuid of this cp specification option
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cp specification option.
	 *
	 * @return the user name of this cp specification option
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cp specification option.
	 *
	 * @param userName the user name of this cp specification option
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cp specification option.
	 *
	 * @return the create date of this cp specification option
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cp specification option.
	 *
	 * @param createDate the create date of this cp specification option
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cp specification option.
	 *
	 * @return the modified date of this cp specification option
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cp specification option.
	 *
	 * @param modifiedDate the modified date of this cp specification option
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the cp option category ID of this cp specification option.
	 *
	 * @return the cp option category ID of this cp specification option
	 */
	public long getCPOptionCategoryId();

	/**
	 * Sets the cp option category ID of this cp specification option.
	 *
	 * @param CPOptionCategoryId the cp option category ID of this cp specification option
	 */
	public void setCPOptionCategoryId(long CPOptionCategoryId);

	/**
	 * Returns the title of this cp specification option.
	 *
	 * @return the title of this cp specification option
	 */
	public String getTitle();

	/**
	 * Returns the localized title of this cp specification option in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized title of this cp specification option
	 */
	@AutoEscape
	public String getTitle(Locale locale);

	/**
	 * Returns the localized title of this cp specification option in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized title of this cp specification option. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getTitle(Locale locale, boolean useDefault);

	/**
	 * Returns the localized title of this cp specification option in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized title of this cp specification option
	 */
	@AutoEscape
	public String getTitle(String languageId);

	/**
	 * Returns the localized title of this cp specification option in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized title of this cp specification option
	 */
	@AutoEscape
	public String getTitle(String languageId, boolean useDefault);

	@AutoEscape
	public String getTitleCurrentLanguageId();

	@AutoEscape
	public String getTitleCurrentValue();

	/**
	 * Returns a map of the locales and localized titles of this cp specification option.
	 *
	 * @return the locales and localized titles of this cp specification option
	 */
	public Map<Locale, String> getTitleMap();

	/**
	 * Sets the title of this cp specification option.
	 *
	 * @param title the title of this cp specification option
	 */
	public void setTitle(String title);

	/**
	 * Sets the localized title of this cp specification option in the language.
	 *
	 * @param title the localized title of this cp specification option
	 * @param locale the locale of the language
	 */
	public void setTitle(String title, Locale locale);

	/**
	 * Sets the localized title of this cp specification option in the language, and sets the default locale.
	 *
	 * @param title the localized title of this cp specification option
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setTitle(String title, Locale locale, Locale defaultLocale);

	public void setTitleCurrentLanguageId(String languageId);

	/**
	 * Sets the localized titles of this cp specification option from the map of locales and localized titles.
	 *
	 * @param titleMap the locales and localized titles of this cp specification option
	 */
	public void setTitleMap(Map<Locale, String> titleMap);

	/**
	 * Sets the localized titles of this cp specification option from the map of locales and localized titles, and sets the default locale.
	 *
	 * @param titleMap the locales and localized titles of this cp specification option
	 * @param defaultLocale the default locale
	 */
	public void setTitleMap(Map<Locale, String> titleMap, Locale defaultLocale);

	/**
	 * Returns the description of this cp specification option.
	 *
	 * @return the description of this cp specification option
	 */
	public String getDescription();

	/**
	 * Returns the localized description of this cp specification option in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized description of this cp specification option
	 */
	@AutoEscape
	public String getDescription(Locale locale);

	/**
	 * Returns the localized description of this cp specification option in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized description of this cp specification option. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getDescription(Locale locale, boolean useDefault);

	/**
	 * Returns the localized description of this cp specification option in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized description of this cp specification option
	 */
	@AutoEscape
	public String getDescription(String languageId);

	/**
	 * Returns the localized description of this cp specification option in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized description of this cp specification option
	 */
	@AutoEscape
	public String getDescription(String languageId, boolean useDefault);

	@AutoEscape
	public String getDescriptionCurrentLanguageId();

	@AutoEscape
	public String getDescriptionCurrentValue();

	/**
	 * Returns a map of the locales and localized descriptions of this cp specification option.
	 *
	 * @return the locales and localized descriptions of this cp specification option
	 */
	public Map<Locale, String> getDescriptionMap();

	/**
	 * Sets the description of this cp specification option.
	 *
	 * @param description the description of this cp specification option
	 */
	public void setDescription(String description);

	/**
	 * Sets the localized description of this cp specification option in the language.
	 *
	 * @param description the localized description of this cp specification option
	 * @param locale the locale of the language
	 */
	public void setDescription(String description, Locale locale);

	/**
	 * Sets the localized description of this cp specification option in the language, and sets the default locale.
	 *
	 * @param description the localized description of this cp specification option
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setDescription(
		String description, Locale locale, Locale defaultLocale);

	public void setDescriptionCurrentLanguageId(String languageId);

	/**
	 * Sets the localized descriptions of this cp specification option from the map of locales and localized descriptions.
	 *
	 * @param descriptionMap the locales and localized descriptions of this cp specification option
	 */
	public void setDescriptionMap(Map<Locale, String> descriptionMap);

	/**
	 * Sets the localized descriptions of this cp specification option from the map of locales and localized descriptions, and sets the default locale.
	 *
	 * @param descriptionMap the locales and localized descriptions of this cp specification option
	 * @param defaultLocale the default locale
	 */
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale);

	/**
	 * Returns the facetable of this cp specification option.
	 *
	 * @return the facetable of this cp specification option
	 */
	public boolean getFacetable();

	/**
	 * Returns <code>true</code> if this cp specification option is facetable.
	 *
	 * @return <code>true</code> if this cp specification option is facetable; <code>false</code> otherwise
	 */
	public boolean isFacetable();

	/**
	 * Sets whether this cp specification option is facetable.
	 *
	 * @param facetable the facetable of this cp specification option
	 */
	public void setFacetable(boolean facetable);

	/**
	 * Returns the key of this cp specification option.
	 *
	 * @return the key of this cp specification option
	 */
	@AutoEscape
	public String getKey();

	/**
	 * Sets the key of this cp specification option.
	 *
	 * @param key the key of this cp specification option
	 */
	public void setKey(String key);

	/**
	 * Returns the last publish date of this cp specification option.
	 *
	 * @return the last publish date of this cp specification option
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this cp specification option.
	 *
	 * @param lastPublishDate the last publish date of this cp specification option
	 */
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public CPSpecificationOption cloneWithOriginalValues();

}