/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.order.rule.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the COREntry service. Represents a row in the &quot;COREntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.order.rule.model.impl.COREntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.order.rule.model.impl.COREntryImpl</code>.
 * </p>
 *
 * @author Luca Pellizzon
 * @see COREntry
 * @generated
 */
@ProviderType
public interface COREntryModel
	extends AuditedModel, BaseModel<COREntry>, ShardedModel, WorkflowedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cor entry model instance should use the {@link COREntry} interface instead.
	 */

	/**
	 * Returns the primary key of this cor entry.
	 *
	 * @return the primary key of this cor entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cor entry.
	 *
	 * @param primaryKey the primary key of this cor entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the external reference code of this cor entry.
	 *
	 * @return the external reference code of this cor entry
	 */
	@AutoEscape
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this cor entry.
	 *
	 * @param externalReferenceCode the external reference code of this cor entry
	 */
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the cor entry ID of this cor entry.
	 *
	 * @return the cor entry ID of this cor entry
	 */
	public long getCOREntryId();

	/**
	 * Sets the cor entry ID of this cor entry.
	 *
	 * @param COREntryId the cor entry ID of this cor entry
	 */
	public void setCOREntryId(long COREntryId);

	/**
	 * Returns the company ID of this cor entry.
	 *
	 * @return the company ID of this cor entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cor entry.
	 *
	 * @param companyId the company ID of this cor entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cor entry.
	 *
	 * @return the user ID of this cor entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cor entry.
	 *
	 * @param userId the user ID of this cor entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cor entry.
	 *
	 * @return the user uuid of this cor entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cor entry.
	 *
	 * @param userUuid the user uuid of this cor entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cor entry.
	 *
	 * @return the user name of this cor entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cor entry.
	 *
	 * @param userName the user name of this cor entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cor entry.
	 *
	 * @return the create date of this cor entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cor entry.
	 *
	 * @param createDate the create date of this cor entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cor entry.
	 *
	 * @return the modified date of this cor entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cor entry.
	 *
	 * @param modifiedDate the modified date of this cor entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the active of this cor entry.
	 *
	 * @return the active of this cor entry
	 */
	public boolean getActive();

	/**
	 * Returns <code>true</code> if this cor entry is active.
	 *
	 * @return <code>true</code> if this cor entry is active; <code>false</code> otherwise
	 */
	public boolean isActive();

	/**
	 * Sets whether this cor entry is active.
	 *
	 * @param active the active of this cor entry
	 */
	public void setActive(boolean active);

	/**
	 * Returns the description of this cor entry.
	 *
	 * @return the description of this cor entry
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this cor entry.
	 *
	 * @param description the description of this cor entry
	 */
	public void setDescription(String description);

	/**
	 * Returns the display date of this cor entry.
	 *
	 * @return the display date of this cor entry
	 */
	public Date getDisplayDate();

	/**
	 * Sets the display date of this cor entry.
	 *
	 * @param displayDate the display date of this cor entry
	 */
	public void setDisplayDate(Date displayDate);

	/**
	 * Returns the expiration date of this cor entry.
	 *
	 * @return the expiration date of this cor entry
	 */
	public Date getExpirationDate();

	/**
	 * Sets the expiration date of this cor entry.
	 *
	 * @param expirationDate the expiration date of this cor entry
	 */
	public void setExpirationDate(Date expirationDate);

	/**
	 * Returns the name of this cor entry.
	 *
	 * @return the name of this cor entry
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this cor entry.
	 *
	 * @param name the name of this cor entry
	 */
	public void setName(String name);

	/**
	 * Returns the priority of this cor entry.
	 *
	 * @return the priority of this cor entry
	 */
	public int getPriority();

	/**
	 * Sets the priority of this cor entry.
	 *
	 * @param priority the priority of this cor entry
	 */
	public void setPriority(int priority);

	/**
	 * Returns the type of this cor entry.
	 *
	 * @return the type of this cor entry
	 */
	@AutoEscape
	public String getType();

	/**
	 * Sets the type of this cor entry.
	 *
	 * @param type the type of this cor entry
	 */
	public void setType(String type);

	/**
	 * Returns the type settings of this cor entry.
	 *
	 * @return the type settings of this cor entry
	 */
	@AutoEscape
	public String getTypeSettings();

	/**
	 * Sets the type settings of this cor entry.
	 *
	 * @param typeSettings the type settings of this cor entry
	 */
	public void setTypeSettings(String typeSettings);

	/**
	 * Returns the last publish date of this cor entry.
	 *
	 * @return the last publish date of this cor entry
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this cor entry.
	 *
	 * @param lastPublishDate the last publish date of this cor entry
	 */
	public void setLastPublishDate(Date lastPublishDate);

	/**
	 * Returns the status of this cor entry.
	 *
	 * @return the status of this cor entry
	 */
	@Override
	public int getStatus();

	/**
	 * Sets the status of this cor entry.
	 *
	 * @param status the status of this cor entry
	 */
	@Override
	public void setStatus(int status);

	/**
	 * Returns the status by user ID of this cor entry.
	 *
	 * @return the status by user ID of this cor entry
	 */
	@Override
	public long getStatusByUserId();

	/**
	 * Sets the status by user ID of this cor entry.
	 *
	 * @param statusByUserId the status by user ID of this cor entry
	 */
	@Override
	public void setStatusByUserId(long statusByUserId);

	/**
	 * Returns the status by user uuid of this cor entry.
	 *
	 * @return the status by user uuid of this cor entry
	 */
	@Override
	public String getStatusByUserUuid();

	/**
	 * Sets the status by user uuid of this cor entry.
	 *
	 * @param statusByUserUuid the status by user uuid of this cor entry
	 */
	@Override
	public void setStatusByUserUuid(String statusByUserUuid);

	/**
	 * Returns the status by user name of this cor entry.
	 *
	 * @return the status by user name of this cor entry
	 */
	@AutoEscape
	@Override
	public String getStatusByUserName();

	/**
	 * Sets the status by user name of this cor entry.
	 *
	 * @param statusByUserName the status by user name of this cor entry
	 */
	@Override
	public void setStatusByUserName(String statusByUserName);

	/**
	 * Returns the status date of this cor entry.
	 *
	 * @return the status date of this cor entry
	 */
	@Override
	public Date getStatusDate();

	/**
	 * Sets the status date of this cor entry.
	 *
	 * @param statusDate the status date of this cor entry
	 */
	@Override
	public void setStatusDate(Date statusDate);

	/**
	 * Returns <code>true</code> if this cor entry is approved.
	 *
	 * @return <code>true</code> if this cor entry is approved; <code>false</code> otherwise
	 */
	@Override
	public boolean isApproved();

	/**
	 * Returns <code>true</code> if this cor entry is denied.
	 *
	 * @return <code>true</code> if this cor entry is denied; <code>false</code> otherwise
	 */
	@Override
	public boolean isDenied();

	/**
	 * Returns <code>true</code> if this cor entry is a draft.
	 *
	 * @return <code>true</code> if this cor entry is a draft; <code>false</code> otherwise
	 */
	@Override
	public boolean isDraft();

	/**
	 * Returns <code>true</code> if this cor entry is expired.
	 *
	 * @return <code>true</code> if this cor entry is expired; <code>false</code> otherwise
	 */
	@Override
	public boolean isExpired();

	/**
	 * Returns <code>true</code> if this cor entry is inactive.
	 *
	 * @return <code>true</code> if this cor entry is inactive; <code>false</code> otherwise
	 */
	@Override
	public boolean isInactive();

	/**
	 * Returns <code>true</code> if this cor entry is incomplete.
	 *
	 * @return <code>true</code> if this cor entry is incomplete; <code>false</code> otherwise
	 */
	@Override
	public boolean isIncomplete();

	/**
	 * Returns <code>true</code> if this cor entry is pending.
	 *
	 * @return <code>true</code> if this cor entry is pending; <code>false</code> otherwise
	 */
	@Override
	public boolean isPending();

	/**
	 * Returns <code>true</code> if this cor entry is scheduled.
	 *
	 * @return <code>true</code> if this cor entry is scheduled; <code>false</code> otherwise
	 */
	@Override
	public boolean isScheduled();

	@Override
	public COREntry cloneWithOriginalValues();

}