/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.batch.planner.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the BatchPlannerLog service. Represents a row in the &quot;BatchPlannerLog&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.batch.planner.model.impl.BatchPlannerLogModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.batch.planner.model.impl.BatchPlannerLogImpl</code>.
 * </p>
 *
 * @author Igor Beslic
 * @see BatchPlannerLog
 * @generated
 */
@ProviderType
public interface BatchPlannerLogModel
	extends AuditedModel, BaseModel<BatchPlannerLog>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a batch planner log model instance should use the {@link BatchPlannerLog} interface instead.
	 */

	/**
	 * Returns the primary key of this batch planner log.
	 *
	 * @return the primary key of this batch planner log
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this batch planner log.
	 *
	 * @param primaryKey the primary key of this batch planner log
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this batch planner log.
	 *
	 * @return the mvcc version of this batch planner log
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this batch planner log.
	 *
	 * @param mvccVersion the mvcc version of this batch planner log
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the batch planner log ID of this batch planner log.
	 *
	 * @return the batch planner log ID of this batch planner log
	 */
	public long getBatchPlannerLogId();

	/**
	 * Sets the batch planner log ID of this batch planner log.
	 *
	 * @param batchPlannerLogId the batch planner log ID of this batch planner log
	 */
	public void setBatchPlannerLogId(long batchPlannerLogId);

	/**
	 * Returns the company ID of this batch planner log.
	 *
	 * @return the company ID of this batch planner log
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this batch planner log.
	 *
	 * @param companyId the company ID of this batch planner log
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this batch planner log.
	 *
	 * @return the user ID of this batch planner log
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this batch planner log.
	 *
	 * @param userId the user ID of this batch planner log
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this batch planner log.
	 *
	 * @return the user uuid of this batch planner log
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this batch planner log.
	 *
	 * @param userUuid the user uuid of this batch planner log
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this batch planner log.
	 *
	 * @return the user name of this batch planner log
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this batch planner log.
	 *
	 * @param userName the user name of this batch planner log
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this batch planner log.
	 *
	 * @return the create date of this batch planner log
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this batch planner log.
	 *
	 * @param createDate the create date of this batch planner log
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this batch planner log.
	 *
	 * @return the modified date of this batch planner log
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this batch planner log.
	 *
	 * @param modifiedDate the modified date of this batch planner log
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the batch planner plan ID of this batch planner log.
	 *
	 * @return the batch planner plan ID of this batch planner log
	 */
	public long getBatchPlannerPlanId();

	/**
	 * Sets the batch planner plan ID of this batch planner log.
	 *
	 * @param batchPlannerPlanId the batch planner plan ID of this batch planner log
	 */
	public void setBatchPlannerPlanId(long batchPlannerPlanId);

	/**
	 * Returns the batch engine export task erc of this batch planner log.
	 *
	 * @return the batch engine export task erc of this batch planner log
	 */
	@AutoEscape
	public String getBatchEngineExportTaskERC();

	/**
	 * Sets the batch engine export task erc of this batch planner log.
	 *
	 * @param batchEngineExportTaskERC the batch engine export task erc of this batch planner log
	 */
	public void setBatchEngineExportTaskERC(String batchEngineExportTaskERC);

	/**
	 * Returns the batch engine import task erc of this batch planner log.
	 *
	 * @return the batch engine import task erc of this batch planner log
	 */
	@AutoEscape
	public String getBatchEngineImportTaskERC();

	/**
	 * Sets the batch engine import task erc of this batch planner log.
	 *
	 * @param batchEngineImportTaskERC the batch engine import task erc of this batch planner log
	 */
	public void setBatchEngineImportTaskERC(String batchEngineImportTaskERC);

	/**
	 * Returns the dispatch trigger erc of this batch planner log.
	 *
	 * @return the dispatch trigger erc of this batch planner log
	 */
	@AutoEscape
	public String getDispatchTriggerERC();

	/**
	 * Sets the dispatch trigger erc of this batch planner log.
	 *
	 * @param dispatchTriggerERC the dispatch trigger erc of this batch planner log
	 */
	public void setDispatchTriggerERC(String dispatchTriggerERC);

	/**
	 * Returns the size of this batch planner log.
	 *
	 * @return the size of this batch planner log
	 */
	public int getSize();

	/**
	 * Sets the size of this batch planner log.
	 *
	 * @param size the size of this batch planner log
	 */
	public void setSize(int size);

	/**
	 * Returns the total of this batch planner log.
	 *
	 * @return the total of this batch planner log
	 */
	public int getTotal();

	/**
	 * Sets the total of this batch planner log.
	 *
	 * @param total the total of this batch planner log
	 */
	public void setTotal(int total);

	/**
	 * Returns the status of this batch planner log.
	 *
	 * @return the status of this batch planner log
	 */
	public int getStatus();

	/**
	 * Sets the status of this batch planner log.
	 *
	 * @param status the status of this batch planner log
	 */
	public void setStatus(int status);

	@Override
	public BatchPlannerLog cloneWithOriginalValues();

}