/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.account.exception;

import com.liferay.portal.kernel.exception.PortalException;

/**
 * @author Brian Wing Shun Chan
 */
public class DefaultAccountGroupException extends PortalException {

	public DefaultAccountGroupException() {
	}

	public DefaultAccountGroupException(String msg) {
		super(msg);
	}

	public DefaultAccountGroupException(String msg, Throwable throwable) {
		super(msg, throwable);
	}

	public DefaultAccountGroupException(Throwable throwable) {
		super(throwable);
	}

	public static class MustNotDeleteDefaultAccountGroup
		extends DefaultAccountGroupException {

		public MustNotDeleteDefaultAccountGroup(long accountGroupId) {
			super(
				String.format(
					"The default account group %s cannot be deleted",
					accountGroupId));

			this.accountGroupId = accountGroupId;
		}

		public long accountGroupId;

	}

	public static class MustNotDuplicateDefaultAccountGroup
		extends DefaultAccountGroupException {

		public MustNotDuplicateDefaultAccountGroup(long companyId) {
			super(
				String.format(
					"There is already a default account group for company %s",
					companyId));

			this.companyId = companyId;
		}

		public long companyId;

	}

	public static class MustNotUpdateDefaultAccountGroup
		extends DefaultAccountGroupException {

		public MustNotUpdateDefaultAccountGroup(long accountGroupId) {
			super(
				String.format(
					"The default account group %s cannot be updated",
					accountGroupId));

			this.accountGroupId = accountGroupId;
		}

		public long accountGroupId;

	}

}