Liferay.Loader.define("layout-taglib@4.1.26/select_layout/js/SelectLayout.es", ['module', 'exports', 'require', 'frontend-taglib/cards_treeview/CardsTreeview.es', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './SelectLayout.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.SelectLayout = void 0;

  require("frontend-taglib/cards_treeview/CardsTreeview.es");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _SelectLayout = _interopRequireDefault(require("./SelectLayout.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * KeyBoardEvent enter key
   * @review
   * @type {!string}
   */
  var ENTER_KEY = 'Enter';
  /**
   * SelectLayout
   *
   * This component shows a list of available layouts to select in expanded tree
   * and allows to filter them by searching.
   *
   * @review
   */

  var SelectLayout = /*#__PURE__*/function (_Component) {
    _inherits(SelectLayout, _Component);

    function SelectLayout() {
      _classCallCheck(this, SelectLayout);

      return _possibleConstructorReturn(this, _getPrototypeOf(SelectLayout).apply(this, arguments));
    }

    _createClass(SelectLayout, [{
      key: "_filterSiblingNodes",

      /**
       * Filters deep nested nodes based on a filtering value
       *
       * @type {Array<Object>} nodes
       * @type {string} filterValue
       * @private
       * @review
       */
      value: function _filterSiblingNodes(nodes, filterValue) {
        var _this = this;

        var filteredNodes = [];
        nodes.forEach(function (node) {
          if (node.name.toLowerCase().indexOf(filterValue) !== -1) {
            filteredNodes.push(node);
          }

          if (node.children) {
            filteredNodes = filteredNodes.concat(_this._filterSiblingNodes(node.children, filterValue));
          }
        });
        return filteredNodes;
      }
      /**
       * When the search form is submitted, nothing should happend,
       * as filtering is performed on keypress.
       * @param {KeyboardEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleSearchFormKeyDown",
      value: function _handleSearchFormKeyDown(event) {
        if (event.key === ENTER_KEY) {
          event.preventDefault();
          event.stopImmediatePropagation();
        }
      }
      /**
       * Searchs for nodes by name based on a filtering value
       *
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_searchNodes",
      value: function _searchNodes(event) {
        if (!this.originalNodes) {
          this.originalNodes = this.nodes;
        } else {
          this.nodes = this.originalNodes;
        }

        var filterValue = event.delegateTarget.value.toLowerCase();

        if (filterValue !== '') {
          this.viewType = SelectLayout.VIEW_TYPES.flat;
          this.nodes = this._filterSiblingNodes(this.nodes, filterValue);
        } else {
          this.viewType = SelectLayout.VIEW_TYPES.tree;
        }
      }
      /**
       * Fires item selector save event on selected node change
       *
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_selectedNodeChange",
      value: function _selectedNodeChange(event) {
        var data = event.newVal.map(function (node) {
          return {
            groupId: node.groupId,
            id: node.id,
            layoutId: node.layoutId,
            name: node.value,
            privateLayout: node.privateLayout,
            value: node.url
          };
        });

        if (!this.multiSelection) {
          data = data[0];
        }

        if (this.followURLOnTitleClick) {
          Liferay.Util.getOpener().document.location.href = data.url;
        } else {
          this.emit(this.itemSelectorSaveEvent, {
            data: data
          });
          Liferay.Util.getOpener().Liferay.fire(this.itemSelectorSaveEvent, {
            data: data
          });
        }
      }
    }]);

    return SelectLayout;
  }(_metalComponent["default"]);
  /**
   * SelectLayout view types
   * @review
   * @static
   * @type {Object}
   */

  exports.SelectLayout = SelectLayout;
  SelectLayout.VIEW_TYPES = {
    flat: 'flat',
    tree: 'tree'
  };
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  SelectLayout.STATE = {
    /**
     * Enables URL following on the title click
     * @default false
     * @instance
     * @memberOf SelectLayout
     * @review
     * @type {boolean}
     */
    followURLOnTitleClick: _metalState.Config.bool().value(false),

    /**
     * Event name to fire on node selection
     * @default ''
     * @instance
     * @memberOf SelectLayout
     * @review
     * @type {string}
     */
    itemSelectorSaveEvent: _metalState.Config.string().value(''),

    /**
     * Enables multiple selection of tree elements
     * @default false
     * @instance
     * @memberOf SelectLayout
     * @review
     * @type {boolean}
     */
    multiSelection: _metalState.Config.bool().value(false),

    /**
     * List of nodes
     * @default undefined
     * @instance
     * @memberOf SelectLayout
     * @review
     * @type {!Array<Object>}
     */
    nodes: _metalState.Config.array().required(),

    /**
     * Theme images root path
     * @default undefined
     * @instance
     * @memberOf SelectLayout
     * @review
     * @type {!string}
     */
    pathThemeImages: _metalState.Config.string().required(),

    /**
     * Type of view to render. Accepted values are defined inside
     * SelectLayout.VIEW_TYPES static property.
     * @default SelectLayout.VIEW_TYPES.tree
     * @instance
     * @memberOf SelectLayout
     * @review
     * @type {string}
     */
    viewType: _metalState.Config.oneOf(Object.values(SelectLayout.VIEW_TYPES)).value(SelectLayout.VIEW_TYPES.tree)
  };

  _metalSoy["default"].register(SelectLayout, _SelectLayout["default"]);

  var _default = SelectLayout;
  exports["default"] = _default;
  //# sourceMappingURL=SelectLayout.es.js.map
});
//# sourceMappingURL=SelectLayout.es.js.map