/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("commerce-frontend-taglib@9.0.0/products_compare/ProductsCompare.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './ProductsCompare.soy', './ProductsCompareItem.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ProductsCompare = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  var _ProductsCompare = _interopRequireDefault(require("./ProductsCompare.soy"));

  require("./ProductsCompareItem.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var ProductsCompare = /*#__PURE__*/function (_Component) {
    _inherits(ProductsCompare, _Component);

    function ProductsCompare() {
      _classCallCheck(this, ProductsCompare);

      return _possibleConstructorReturn(this, _getPrototypeOf(ProductsCompare).apply(this, arguments));
    }

    _createClass(ProductsCompare, [{
      key: "created",
      value: function created() {
        window.Liferay.on('toggleProductToCompare', this._handleToggleProductToCompare, this);
      }
    }, {
      key: "detached",
      value: function detached() {
        window.Liferay.detach('toggleProductToCompare', this._handleToggleProductToCompare, this);
      }
    }, {
      key: "_handleToggleProductToCompare",
      value: function _handleToggleProductToCompare(data) {
        var toggledProduct = {
          id: data.id,
          thumbnail: data.thumbnail
        };
        var included = this.products.reduce(function (acc, el) {
          return acc || el.id === data.id;
        }, false);
        return included ? this._handleRemoveProduct(toggledProduct) : this._handleAddProduct(toggledProduct);
      }
    }, {
      key: "_addProduct",
      value: function _addProduct(product) {
        this.products = this.products.concat({
          id: product.id,
          thumbnail: product.thumbnail,
          visibility: 'hidden'
        });
        return this._updateProductVisibility(product.id, 'visible');
      }
    }, {
      key: "_removeProduct",
      value: function _removeProduct(product) {
        var _this = this;

        this._updateProductVisibility(product.id, 'hidden');

        this._toogleRemoteStatus(product.id, false);

        return new Promise(function (resolve) {
          return setTimeout(function () {
            _this.products = _this.products.filter(function (el) {
              return el.id !== product.id;
            });
            Liferay.fire('productRemovedFromCompare', product);
            return resolve(_this.products);
          }, 500);
        });
      }
    }, {
      key: "_toogleRemoteStatus",
      value: function _toogleRemoteStatus(id, toogle) {
        var formData = new FormData();
        formData.append(this.portletNamespace + 'cpDefinitionId', id);
        formData.append(this.portletNamespace + id + 'Compare', toogle);
        formData.append('p_auth', Liferay.authToken);
        return fetch(this.editCompareProductActionURL, {
          body: formData,
          credentials: 'include',
          headers: new Headers({
            'x-csrf-token': Liferay.authToken
          }),
          method: 'post'
        });
      }
    }, {
      key: "_handleAddProduct",
      value: function _handleAddProduct(product) {
        var _this2 = this;

        return this._addProduct(product).then(function () {
          return _this2._toogleRemoteStatus(product.id, true);
        }).then(function () {
          return _this2._updateCompareGlobalState();
        });
      }
    }, {
      key: "_handleRemoveProduct",
      value: function _handleRemoveProduct(product) {
        var _this3 = this;

        return this._removeProduct(product).then(function () {
          return _this3._updateCompareGlobalState();
        });
      }
    }, {
      key: "_updateCompareGlobalState",
      value: function _updateCompareGlobalState() {
        return this.products.length < this.limit ? Liferay.fire('compareIsAvailable') : Liferay.fire('compareIsUnavailable');
      }
    }, {
      key: "_updateProductVisibility",
      value: function _updateProductVisibility(id) {
        var _this4 = this;

        var toState = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'visible';
        return new Promise(function (resolve) {
          setTimeout(function () {
            _this4.products = _this4.products.map(function (el) {
              return el.id === id ? {
                id: el.id,
                thumbnail: el.thumbnail,
                visibility: toState === 'visible' ? 'showing' : 'hiding'
              } : el;
            });
            return _this4.products;
          }, 100);
          return setTimeout(function () {
            _this4.products = _this4.products.map(function (el) {
              return el.id === id ? {
                id: el.id,
                thumbnail: el.thumbnail,
                visibility: toState
              } : el;
            });
            return resolve(_this4.products);
          }, 400);
        });
      }
    }, {
      key: "_submitCompare",
      value: function _submitCompare() {
        if (Liferay.SPA) {
          Liferay.SPA.app.navigate(this.compareProductsURL);
        } else {
          window.location.href = this.compareProductsURL;
        }
      }
    }]);

    return ProductsCompare;
  }(_metalComponent["default"]);

  exports.ProductsCompare = ProductsCompare;

  _metalSoy["default"].register(ProductsCompare, _ProductsCompare["default"]);

  ProductsCompare.STATE = {
    compareProductsURL: _metalSoy.Config.string().required(),
    editCompareProductActionURL: _metalSoy.Config.string(),
    limit: _metalSoy.Config.number().required(),
    portletNamespace: _metalSoy.Config.string().required(),
    products: _metalSoy.Config.array(_metalSoy.Config.object()).value([]),
    spritemap: _metalSoy.Config.string()
  };
  var _default = ProductsCompare;
  exports["default"] = _default;
  //# sourceMappingURL=ProductsCompare.es.js.map
});
//# sourceMappingURL=ProductsCompare.es.js.map