/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ant;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;

public class GetFileSetTask
extends Task {
    private static final String _PATH_STRING_SRC_MAIN_JAVA = String.valueOf(Paths.get("src", "main", "java"));
    private static final Logger _logger = Logger.getLogger(GetFileSetTask.class.getName());
    private static final List<String> _skipFileNames = Arrays.asList("benchmarks", "definitions", "gradle", "lib", "nbproject", "oss-licenses", "portal-client", "readme", "sql", "tools");
    private static final List<String> _skipModuleFileNames = Arrays.asList("node_modules");
    private String _classNames;
    private String _rootDirName;

    public void execute() throws BuildException {
        ArrayList<String> classNames = new ArrayList<String>();
        Collections.addAll(classNames, this._classNames.split(","));
        HashSet<String> invalidClassNames = new HashSet<String>();
        if (!this._hasInvalidClassNames(classNames, invalidClassNames)) {
            _logger.log(Level.WARNING, "Input class names instead of test class names: {0}", ((Object)invalidClassNames).toString());
            return;
        }
        File baseDir = new File(this._rootDirName);
        ArrayList<Path> classPaths = new ArrayList<Path>();
        ArrayList<Path> srcPaths = new ArrayList<Path>();
        Set<String> missingClassNames = this._getMissingClassNames(baseDir, classNames, classPaths, srcPaths);
        if (!missingClassNames.isEmpty()) {
            _logger.log(Level.WARNING, "No class files found for: {0}", missingClassNames.toString());
            if (classPaths.isEmpty()) {
                return;
            }
        }
        Project project = this.getProject();
        FileSet classFileSet = new FileSet();
        classFileSet.setDir(baseDir);
        for (Path classPath : classPaths) {
            String classPathString = String.valueOf(classPath);
            classPathString = classPathString.substring(this._rootDirName.length() + 1);
            classFileSet.setIncludes(classPathString);
        }
        classFileSet.setProject(this.getProject());
        project.addReference("get.file.set.class.set", (Object)classFileSet);
        DirSet srcDirSet = new DirSet();
        srcDirSet.setDir(baseDir);
        for (Path srcPath : srcPaths) {
            String srcPathString = String.valueOf(srcPath);
            if (!this._isInvalidClassName(srcPathString, invalidClassNames)) {
                _logger.log(Level.WARNING, "Invalid class name: {0}", ((Object)invalidClassNames).toString());
                return;
            }
            int index = srcPathString.indexOf("src") + 3;
            if (srcPathString.contains(_PATH_STRING_SRC_MAIN_JAVA)) {
                index = srcPathString.indexOf(_PATH_STRING_SRC_MAIN_JAVA) + _PATH_STRING_SRC_MAIN_JAVA.length();
            }
            srcPathString = srcPathString.substring(this._rootDirName.length() + 1, index);
            srcDirSet.setIncludes(srcPathString);
        }
        srcDirSet.setProject(project);
        project.addReference("get.file.set.src.set", (Object)srcDirSet);
    }

    public void setClassNames(String classNames) {
        this._classNames = classNames;
    }

    public void setRootDir(String rootDirName) {
        this._rootDirName = rootDirName;
    }

    private Set<String> _getMissingClassNames(File baseDir, final List<String> classNames, final List<Path> classPaths, final List<Path> srcPaths) {
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            throw new BuildException();
        }
        final HashSet<String> missingClassNames = new HashSet<String>();
        missingClassNames.addAll(classNames);
        try {
            Files.walkFileTree(baseDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path parentDir;
                    String fileName = String.valueOf(path.getFileName());
                    if (GetFileSetTask.this._isSkip(fileName, (parentDir = path.getParent()).toString())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    String fileName = String.valueOf(path.getFileName());
                    for (String className : classNames) {
                        if (GetFileSetTask.this._isClass(className, fileName)) {
                            classPaths.add(path);
                            missingClassNames.remove(className);
                            continue;
                        }
                        if (!fileName.equals(className.concat(".java"))) continue;
                        srcPaths.add(path);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new BuildException((Throwable)ioException);
        }
        return missingClassNames;
    }

    private boolean _hasInvalidClassNames(List<String> classNames, Set<String> invalidClassNames) {
        for (String className : classNames) {
            if (!className.endsWith("Test")) continue;
            invalidClassNames.add(className);
        }
        return invalidClassNames.isEmpty();
    }

    private boolean _isClass(String className, String fileName) {
        return fileName.equals(className.concat(".class")) || fileName.startsWith(className.concat("$")) && fileName.endsWith(".class");
    }

    private boolean _isInvalidClassName(String absoluteFileName, Set<String> invalidClassNames) {
        if (!absoluteFileName.contains("src")) {
            int x = absoluteFileName.lastIndexOf(File.separator);
            int y = absoluteFileName.lastIndexOf(".");
            invalidClassNames.add(absoluteFileName.substring(x + 1, y));
            return false;
        }
        return true;
    }

    private boolean _isSkip(String fileName, String parentDirName) {
        return fileName.startsWith(".") || _skipModuleFileNames.contains(fileName) || _skipFileNames.contains(fileName) && parentDirName.equals(this._rootDirName);
    }
}

