/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.resiliency.spi.provider;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.resiliency.spi.provider.SPIProvider;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class SPIClassPathContextListener
implements ServletContextListener {
    public static volatile String SPI_CLASS_PATH = "";
    protected static final AtomicReference<SPIProvider> spiProviderReference = new AtomicReference();
    private static final Log _log = LogFactoryUtil.getLog(SPIClassPathContextListener.class);

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        SPIProvider spiProvider = spiProviderReference.getAndSet(null);
        if (spiProvider != null) {
            MPIHelperUtil.unregisterSPIProvider((SPIProvider)spiProvider);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        String contextPath = servletContext.getRealPath("");
        String spiEmbeddedLibDirName = servletContext.getInitParameter("spiEmbeddedLibDir");
        LinkedHashSet<File> jarFiles = new LinkedHashSet<File>();
        File spiEmbeddedLibDir = new File(contextPath, spiEmbeddedLibDirName);
        this.addJarFiles(jarFiles, spiEmbeddedLibDir);
        this.addJarFiles(jarFiles, PortalClassLoaderUtil.getClassLoader(), PortalException.class.getName());
        this.addJarFiles(jarFiles, PortalClassLoaderUtil.getClassLoader(), PropsUtil.get((String)"jdbc.default.driverClassName"));
        this.addJarFiles(jarFiles, new File(spiEmbeddedLibDir, "ext"));
        StringBundler sb = new StringBundler(jarFiles.size() * 2 + 2);
        for (File file : jarFiles) {
            sb.append(file.getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        sb.append(contextPath);
        sb.append("/WEB-INF/classes");
        SPI_CLASS_PATH = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SPI class path " + SPI_CLASS_PATH));
        }
        String spiProviderClassName = servletContext.getInitParameter("spiProviderClassName");
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            Class<?> spiProviderClass = null;
            spiProviderClass = SPIUtil.isSPI() ? SPIClassPathContextListener.loadClassDirectly(contextClassLoader, spiProviderClassName) : contextClassLoader.loadClass(spiProviderClassName);
            SPIProvider spiProvider = (SPIProvider)spiProviderClass.newInstance();
            boolean result = spiProviderReference.compareAndSet(null, spiProvider);
            if (!result) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Duplicate SPI provider ", spiProvider, " is already registered in servlet context ", servletContext.getContextPath()}));
            } else {
                MPIHelperUtil.registerSPIProvider((SPIProvider)spiProvider);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to create SPI provider with name " + spiProviderClassName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Class<?> loadClassDirectly(ClassLoader classLoader, String className) throws Exception {
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            Method findLoadedClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"findLoadedClass", (Class[])new Class[]{String.class});
            Class clazz = (Class)findLoadedClassMethod.invoke((Object)classLoader, className);
            if (clazz == null) {
                Method findClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"findClass", (Class[])new Class[]{String.class});
                clazz = (Class)findClassMethod.invoke((Object)classLoader, className);
            }
            Method resolveClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"resolveClass", (Class[])new Class[]{Class.class});
            resolveClassMethod.invoke((Object)classLoader, clazz);
            return clazz;
        }
    }

    protected void addJarFiles(Set<File> jarFiles, ClassLoader classLoader, String className) {
        String path = ClassUtil.getParentPath((ClassLoader)classLoader, (String)className);
        int pos = path.lastIndexOf(".jar");
        pos = path.lastIndexOf(47, pos);
        path = path.substring(0, pos);
        this.addJarFiles(jarFiles, new File(path));
    }

    protected void addJarFiles(Set<File> jarFiles, File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("Unable to find directory " + dir.getAbsolutePath());
        }
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            String fileName = ((File)file).getName();
            if (!fileName.endsWith(".jar")) continue;
            jarFiles.add((File)file);
        }
    }
}

