/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletSession;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class SessionParameters {
    public static final String KEY = SessionParameters.class.getName();
    public static final boolean USE_SESSION_PARAMETERS = GetterUtil.getBoolean((String)SystemProperties.get((String)SessionParameters.class.getName()), (boolean)true);
    private static final Log _log = LogFactoryUtil.getLog(SessionParameters.class);

    public static String get(HttpServletRequest httpServletRequest, String parameter) {
        return SessionParameters.get(httpServletRequest.getSession(), parameter);
    }

    public static String get(HttpSession httpSession, String parameter) {
        if (!USE_SESSION_PARAMETERS) {
            return parameter;
        }
        Map<String, String> parameters = SessionParameters._getParameters(httpSession);
        Object newParameter = parameters.get(parameter);
        if (newParameter == null) {
            newParameter = StringUtil.randomString() + "_" + parameter;
            parameters.put(parameter, (String)newParameter);
        }
        return newParameter;
    }

    public static String get(PortletRequest portletRequest, String parameter) {
        return SessionParameters.get(portletRequest.getPortletSession(), parameter);
    }

    public static String get(PortletSession portletSession, String parameter) {
        if (!USE_SESSION_PARAMETERS) {
            return parameter;
        }
        Map<String, String> parameters = SessionParameters._getParameters(portletSession);
        Object newParameter = parameters.get(parameter);
        if (newParameter == null) {
            newParameter = StringUtil.randomString() + "_" + parameter;
            parameters.put(parameter, (String)newParameter);
        }
        return newParameter;
    }

    private static Map<String, String> _getParameters(HttpSession httpSession) {
        HashMap<String, String> parameters = null;
        try {
            parameters = (HashMap<String, String>)httpSession.getAttribute(KEY);
            if (parameters == null) {
                parameters = new HashMap();
                httpSession.setAttribute(KEY, parameters);
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalStateException);
            }
            parameters = new HashMap<String, String>();
        }
        return parameters;
    }

    private static Map<String, String> _getParameters(PortletSession portletSession) {
        LinkedHashMap<String, String> parameters = null;
        try {
            parameters = (LinkedHashMap<String, String>)portletSession.getAttribute(KEY);
            if (parameters == null) {
                parameters = new LinkedHashMap();
                portletSession.setAttribute(KEY, parameters);
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalStateException);
            }
            parameters = new LinkedHashMap<String, String>();
        }
        return parameters;
    }
}

