/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.io.ProtectedObjectInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.ProtectedClassLoaderObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class SerializableUtil {
    public static Object clone(Object object) {
        Class<?> clazz = object.getClass();
        return SerializableUtil.deserialize(SerializableUtil.serialize(object), clazz.getClassLoader());
    }

    public static Object deserialize(byte[] bytes) {
        Object object;
        ProtectedObjectInputStream objectInputStream = new ProtectedObjectInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
        try {
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        objectInputStream.close();
        return object;
    }

    public static Object deserialize(byte[] bytes, ClassLoader classLoader) {
        Object object;
        ProtectedClassLoaderObjectInputStream objectInputStream = new ProtectedClassLoaderObjectInputStream((InputStream)new UnsyncByteArrayInputStream(bytes), classLoader);
        try {
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        objectInputStream.close();
        return object;
    }

    public static byte[] serialize(Object object) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);){
            objectOutputStream.writeObject(object);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }
}

