/* Generated By:JavaCC: Do not edit this line. EhcacheSearchParser.java */
package net.sf.ehcache.search.parser;
import java.text.DateFormat;
import net.sf.ehcache.search.parser.ParserSupport;
import java.util.LinkedList;
import java.util.List;
import java.util.ArrayList;
import net.sf.ehcache.search.parser.ParseModel;
import net.sf.ehcache.search.parser.MAttribute;
import net.sf.ehcache.search.parser.MCriteria;
import net.sf.ehcache.search.parser.MAggregate;
import net.sf.ehcache.search.parser.MTarget;
import net.sf.ehcache.search.parser.MValue;
import net.sf.ehcache.search.parser.ModelElement;
import net.sf.ehcache.search.parser.InteractiveCmd;
import net.sf.ehcache.search.parser.CustomParseException;
import net.sf.ehcache.search.parser.CustomParseException.Message;

public class EhcacheSearchParser implements EhcacheSearchParserConstants {
  static final class StringAndToken
  {
    Token token;
    String string;
    StringAndToken(Token tok, String s)
    {
      this.token = tok;
      this.string = s;
    }
  }

  private ParseModel qmodel;

  public ParseModel getModel()
  {
    return qmodel;
  }

  final public InteractiveCmd InteractiveCommand() throws ParseException {
  InteractiveCmd cmd;
  String s;
  ParseModel qm;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_USE_CACHE:
      s = UseCache();
      jj_consume_token(0);
    cmd = new InteractiveCmd(InteractiveCmd.Cmd.UseCache, s);
      break;
    case KW_USE_CACHE_MANAGER:
      s = UseCacheManager();
      jj_consume_token(0);
    cmd = new InteractiveCmd(InteractiveCmd.Cmd.UseCacheManager, s);
      break;
    case KW_SELECT:
      qm = QueryStatement();
    cmd = new InteractiveCmd(qm);
    {if (true) return cmd;}
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Production for specifying a cache to use.
 */
  final public String UseCache() throws ParseException {
  StringAndToken s;
    jj_consume_token(KW_USE_CACHE);
    s = SingleQuotedString();
    {if (true) return s.string;}
    throw new Error("Missing return statement in function");
  }

/**
 * Production for specifying a cache manager to use.
 */
  final public String UseCacheManager() throws ParseException {
  StringAndToken s;
    jj_consume_token(KW_USE_CACHE_MANAGER);
    s = SingleQuotedString();
    {if (true) return s.string;}
    throw new Error("Missing return statement in function");
  }

/**
 * Select production.
 */
  final public ParseModel QueryStatement() throws ParseException {
  this.qmodel = new ParseModel();
  MCriteria crit = null;
  String cacheName;
    jj_consume_token(KW_SELECT);
    TargetList();
    jj_consume_token(KW_FROM);
    cacheName = CacheName();
                                                                    this.qmodel.setCacheName(cacheName);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_WHERE:
      jj_consume_token(KW_WHERE);
      crit = Criteria();
        this.qmodel.setCriteria(crit);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    PostScript();
    jj_consume_token(0);
    {if (true) return qmodel;}
    throw new Error("Missing return statement in function");
  }

/*
Token Select() :
{
  Token t;
}
{
    (
        t = < KW_SELECT > | t = < STRING >
    )
    {
        return t;
    }

}
*/

/**
 * THe tail end of a select statement, covering group by, order by and limit.
 */
  final public void PostScript() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_ORDER_BY:
      case KW_GROUP_BY:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_GROUP_BY:
        GroupBy();
        break;
      case KW_ORDER_BY:
        OrderBy();
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_LIMIT:
      Limit();
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
  }

/**
 * Group by production.
 */
  final public void GroupBy() throws ParseException {
  MAttribute attr1;
  MAttribute attr2;
    jj_consume_token(KW_GROUP_BY);
    attr1 = Attribute();
      this.qmodel.addGroupBy(attr1);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_COMMA:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_2;
      }
      jj_consume_token(KW_COMMA);
      attr2 = Attribute();
            this.qmodel.addGroupBy(attr2);
    }
  }

/**
 * Order by production.
 */
  final public void OrderBy() throws ParseException {
  boolean isAsc = true;
  MAttribute attr1;
  MAttribute attr2;
    jj_consume_token(KW_ORDER_BY);
    attr1 = Attribute();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_SHORT_DESC:
    case KW_SHORT_ASC:
    case KW_DESC:
    case KW_ASC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_ASC:
        jj_consume_token(KW_ASC);
        break;
      case KW_DESC:
        jj_consume_token(KW_DESC);
        isAsc = false;
        break;
      case KW_SHORT_ASC:
        jj_consume_token(KW_SHORT_ASC);
        break;
      case KW_SHORT_DESC:
        jj_consume_token(KW_SHORT_DESC);
        isAsc = false;
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
      this.qmodel.addOrderBy(attr1, isAsc);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_COMMA:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      jj_consume_token(KW_COMMA);
      attr2 = Attribute();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_SHORT_DESC:
      case KW_SHORT_ASC:
      case KW_DESC:
      case KW_ASC:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case KW_ASC:
          jj_consume_token(KW_ASC);
          break;
        case KW_DESC:
          jj_consume_token(KW_DESC);
            isAsc = false;
          break;
        case KW_SHORT_ASC:
          jj_consume_token(KW_SHORT_ASC);
          break;
        case KW_SHORT_DESC:
          jj_consume_token(KW_SHORT_DESC);
            isAsc = false;
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
            this.qmodel.addOrderBy(attr2, isAsc);
    }
  }

/**
 * Limit production. 
 */
  final public void Limit() throws ParseException {
  Token t;
    jj_consume_token(KW_LIMIT);
    t = jj_consume_token(FIXEDINT);
    int lim = Integer.parseInt(t.image);
    this.qmodel.setLimit(lim);
  }

/**
 * One monolithic criteria. 
 */
  final public MCriteria Criteria() throws ParseException {
  MCriteria crit;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_OPEN_PAREN:
      crit = PCriteria();
      break;
    case KW_STAR:
    case KW_ALL:
    case KW_KEY:
    case KW_VALUE:
    case STRING:
      crit = SimpleCriteria();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return crit;}
    throw new Error("Missing return statement in function");
  }

  final public String CacheName() throws ParseException {
  String name;
    name = UnQuotedString();
     {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

/**
 * A parenthesized criterium. Not, And, Or.
 */
  final public MCriteria PCriteria() throws ParseException {
  MCriteria crit;
  List < MCriteria > crits = new ArrayList < MCriteria > (10);
  boolean isNot = false;
  boolean isAnd = false;
    jj_consume_token(KW_OPEN_PAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_NOT:
      jj_consume_token(KW_NOT);
      crit = PCriteria();
      crits.add(crit);
      isNot = true;
      break;
    case KW_STAR:
    case KW_ALL:
    case KW_OPEN_PAREN:
    case KW_KEY:
    case KW_VALUE:
    case STRING:
      crit = Criteria();
        crits.add(crit);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_IN:
      case KW_AND:
      case KW_OR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case KW_OR:
          label_4:
          while (true) {
            jj_consume_token(KW_OR);
            crit = Criteria();
            crits.add(crit);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case KW_OR:
              ;
              break;
            default:
              jj_la1[12] = jj_gen;
              break label_4;
            }
          }
          break;
        case KW_AND:
          label_5:
          while (true) {
            jj_consume_token(KW_AND);
            crit = Criteria();
            crits.add(crit);
            isAnd = true;
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case KW_AND:
              ;
              break;
            default:
              jj_la1[13] = jj_gen;
              break label_5;
            }
          }
          break;
        case KW_IN:
          label_6:
          while (true) {
            jj_consume_token(KW_IN);
            crit = Criteria();
              crits.add(crit);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case KW_IN:
              ;
              break;
            default:
              jj_la1[14] = jj_gen;
              break label_6;
            }
          }
          break;
        default:
          jj_la1[15] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(KW_CLOSED_PAREN);
    MCriteria ret;
    if (crits.size() == 1)
    {
      ret = crits.get(0);
    }
    else if (isAnd)
    {
      ret = new MCriteria.And(crits.toArray(new MCriteria [ 0 ]));
    }
    else
    {
      ret = new MCriteria.Or(crits.toArray(new MCriteria [ 0 ]));
    }
    if (isNot)
    {
      ret = new MCriteria.Not(ret);
    }
    {if (true) return ret;}
    throw new Error("Missing return statement in function");
  }

/**
 * A 'simple' criteria production, i.e. {@code , =,<. etc, like, ilike, in, or between}.
 */
  final public MCriteria SimpleCriteria() throws ParseException {
  MAttribute attr;
  MCriteria.SimpleOp op;
  ModelElement<? > v1 = null;
  MCriteria crit;
    attr = Attribute();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_EQ:
    case KW_NE:
    case KW_NULL:
    case KW_NOT_NULL:
    case KW_GE:
    case KW_GT:
    case KW_LE:
    case KW_LT:
      op = SimpleCriteriaOp();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_OPEN_PAREN:
      case KW_BOOL_CAST:
      case KW_BYTE_CAST:
      case KW_INT_CAST:
      case KW_SHORT_CAST:
      case KW_LONG_CAST:
      case KW_FLOAT_CAST:
      case KW_DOUBLE_CAST:
      case KW_DATE_CAST:
      case KW_SQLDATE_CAST:
      case KW_CHAR_CAST:
      case FIXEDINT:
      case QUOTEDSTR:
        v1 = Value();
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      crit = new MCriteria.Simple(attr, op, v1);
      break;
    case KW_ILIKE:
      crit = ILikeCriteria(attr);
      break;
    case KW_LIKE:
      crit = LikeCriteria(attr);
      break;
    case KW_IN:
      crit = InCriteria(attr);
      break;
    case KW_BETWEEN:
      crit = SQLBetweenCriteria(attr);
      break;
    case KW_ISBETWEEN:
      crit = IsBetweenCriteria(attr);
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return crit;}
    throw new Error("Missing return statement in function");
  }

/**
 * A isbetween production completion. [] are used to indicate inclusivity of the endpoints.
 */
  final public MCriteria IsBetweenCriteria(MAttribute attr) throws ParseException {
  ModelElement<? > v1;
  ModelElement<? > v2;
  boolean includeLower = false;
  boolean includeUpper = false;
    jj_consume_token(KW_ISBETWEEN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_LSQUARE:
      jj_consume_token(KW_LSQUARE);
    includeLower = true;
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    v1 = Value();
    v2 = Value();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_RSQUARE:
      jj_consume_token(KW_RSQUARE);
    includeUpper = true;
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    {if (true) return new MCriteria.Between(attr, v1, includeLower, v2, includeUpper);}
    throw new Error("Missing return statement in function");
  }

/**
 * A SQL-92 between production completion. This form is always inclusive of the ranges.
 */
  final public MCriteria SQLBetweenCriteria(MAttribute attr) throws ParseException {
  ModelElement<? > v1;
  ModelElement<? > v2;
  boolean includeLower = true;
  boolean includeUpper = true;
    jj_consume_token(KW_BETWEEN);
    v1 = Value();
    jj_consume_token(KW_AND);
    v2 = Value();
    {if (true) return new MCriteria.Between(attr, v1, includeLower, v2, includeUpper);}
    throw new Error("Missing return statement in function");
  }

/**
 * A IN criteria completion production. Included for completeness with SQL 92.
 */
  final public MCriteria InCriteria(MAttribute attr) throws ParseException {
  StringAndToken s;
  MValue val;
  List < MCriteria > crits = new ArrayList < MCriteria > (10);
    jj_consume_token(KW_IN);
    jj_consume_token(KW_OPEN_PAREN);
    val = Value();
                   crits.add(new MCriteria.Simple(attr, MCriteria.SimpleOp.EQ, val));
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_COMMA:
        ;
        break;
      default:
        jj_la1[22] = jj_gen;
        break label_7;
      }
      jj_consume_token(KW_COMMA);
      val = Value();
                        crits.add(new MCriteria.Simple(attr, MCriteria.SimpleOp.EQ, val));
    }
    jj_consume_token(KW_CLOSED_PAREN);
    {if (true) return new MCriteria.Or(crits.toArray(new MCriteria [ crits.size() ]));}
    throw new Error("Missing return statement in function");
  }

/**
 * An ilike criteria completion production. 
 */
  final public MCriteria ILikeCriteria(MAttribute attr) throws ParseException {
  StringAndToken s;
    jj_consume_token(KW_ILIKE);
    s = SingleQuotedString();
    {if (true) return new MCriteria.ILike(attr, s.string);}
    throw new Error("Missing return statement in function");
  }

/**
 * A like criteria completion production. Included for completeness with SQL 92.
 */
  final public MCriteria LikeCriteria(MAttribute attr) throws ParseException {
  StringAndToken s;
    jj_consume_token(KW_LIKE);
    s = SingleQuotedString();
    {if (true) return new MCriteria.Like(attr, s.string);}
    throw new Error("Missing return statement in function");
  }

/**
 * A 'simple' criteria operation, like equals, not equals, less than, etc. .
 */
  final public MCriteria.SimpleOp SimpleCriteriaOp() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_EQ:
      t = jj_consume_token(KW_EQ);
      {if (true) return MCriteria.SimpleOp.EQ;}
      break;
    case KW_NE:
      t = jj_consume_token(KW_NE);
      {if (true) return MCriteria.SimpleOp.NE;}
      break;
    case KW_NULL:
      t = jj_consume_token(KW_NULL);
      {if (true) return MCriteria.SimpleOp.NULL;}
      break;
    case KW_NOT_NULL:
      t = jj_consume_token(KW_NOT_NULL);
      {if (true) return MCriteria.SimpleOp.NOT_NULL;}
      break;
    case KW_LT:
      t = jj_consume_token(KW_LT);
      {if (true) return MCriteria.SimpleOp.LT;}
      break;
    case KW_GT:
      t = jj_consume_token(KW_GT);
      {if (true) return MCriteria.SimpleOp.GT;}
      break;
    case KW_LE:
      t = jj_consume_token(KW_LE);
      {if (true) return MCriteria.SimpleOp.LE;}
      break;
    case KW_GE:
      t = jj_consume_token(KW_GE);
      {if (true) return MCriteria.SimpleOp.GE;}
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Value. Right hand side of a comparison. Understands Thrift's primitives, plus enum
 * casting.
 */
  final public MValue Value() throws ParseException {
  Token t = null;
  Token t2;
  StringAndToken s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTEDSTR:
      s = SingleQuotedString();
      {if (true) return new MValue.MString(s.token, s.string);}
      break;
    case KW_CHAR_CAST:
      t = jj_consume_token(KW_CHAR_CAST);
      s = SingleQuotedString();
        {if (true) return new MValue.MChar(s.token, s.string);}
      break;
    case FIXEDINT:
      t = jj_consume_token(FIXEDINT);
      {if (true) return new MValue.MInt(t, t.image);}
      break;
    case KW_BOOL_CAST:
      t = jj_consume_token(KW_BOOL_CAST);
      s = SingleQuotedString();
      {if (true) return new MValue.MBool(s.token, s.string);}
      break;
    case KW_BYTE_CAST:
      jj_consume_token(KW_BYTE_CAST);
      t = jj_consume_token(FIXEDINT);
      {if (true) return new MValue.MByte(t, t.image);}
      break;
    case KW_INT_CAST:
      jj_consume_token(KW_INT_CAST);
      t = jj_consume_token(FIXEDINT);
      {if (true) return new MValue.MInt(t, t.image);}
      break;
    case KW_SHORT_CAST:
      jj_consume_token(KW_SHORT_CAST);
      t = jj_consume_token(FIXEDINT);
      {if (true) return new MValue.MShort(t, t.image);}
      break;
    case KW_LONG_CAST:
      jj_consume_token(KW_LONG_CAST);
      t = jj_consume_token(FIXEDINT);
      {if (true) return new MValue.MLong(t, t.image);}
      break;
    case KW_FLOAT_CAST:
      t = jj_consume_token(KW_FLOAT_CAST);
      s = SingleQuotedString();
      {if (true) return new MValue.MFloat(s.token, s.string);}
      break;
    case KW_DOUBLE_CAST:
      t = jj_consume_token(KW_DOUBLE_CAST);
      s = SingleQuotedString();
      {if (true) return new MValue.MDouble(s.token, s.string);}
      break;
    case KW_SQLDATE_CAST:
      t = jj_consume_token(KW_SQLDATE_CAST);
      s = SingleQuotedString();
      {if (true) return new MValue.MSqlDate(s.token, s.string);}
      break;
    case KW_DATE_CAST:
      t = jj_consume_token(KW_DATE_CAST);
      s = SingleQuotedString();
      {if (true) return new MValue.MJavaDate(s.token, s.string);}
      break;
    case KW_OPEN_PAREN:
      jj_consume_token(KW_OPEN_PAREN);
      t = jj_consume_token(ENUMFQCLASSNAME);
      jj_consume_token(KW_CLOSED_PAREN);
      s = SingleQuotedString();
              {if (true) return new MValue.MEnum(t, t.image.substring("enum".length()).trim(), s.string);}
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) throw new UnsupportedOperationException("Fall through/null in Value()");}
    throw new Error("Missing return statement in function");
  }

/**
 * List of targets to retrieve in a select.
 */
  final public void TargetList() throws ParseException {
  MTarget mt;
    SingleTarget();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_COMMA:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_8;
      }
      jj_consume_token(KW_COMMA);
      SingleTarget();
    }
  }

/**
 * A single target for selecting into. An attribute or an aggregate. 
 */
  final public void SingleTarget() throws ParseException {
  MAttribute m;
  MAggregate agg;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_STAR:
      jj_consume_token(KW_STAR);
      this.qmodel.includeTargetStar();
      break;
    case KW_ALL:
      jj_consume_token(KW_ALL);
      this.qmodel.includeTargetStar();
      break;
    case KW_KEY:
    case KW_VALUE:
    case STRING:
      m = Attribute();
      this.qmodel.includeTargetAttribute(m);
      break;
    case KW_SUM:
    case KW_MAX:
    case KW_MIN:
    case KW_AVG:
    case KW_COUNT:
      agg = Aggregate();
      this.qmodel.includeTargetAggregator(agg);
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Aggregate production. Used like sum('foo'). Sum/min/max/average/count.
 */
  final public MAggregate Aggregate() throws ParseException {
  MAttribute ma;
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_SUM:
      jj_consume_token(KW_SUM);
      jj_consume_token(KW_OPEN_PAREN);
      ma = Attribute();
      jj_consume_token(KW_CLOSED_PAREN);
      {if (true) return new MAggregate(MAggregate.AggOp.Sum, ma);}
      break;
    case KW_MIN:
      jj_consume_token(KW_MIN);
      jj_consume_token(KW_OPEN_PAREN);
      ma = Attribute();
      jj_consume_token(KW_CLOSED_PAREN);
      {if (true) return new MAggregate(MAggregate.AggOp.Min, ma);}
      break;
    case KW_MAX:
      jj_consume_token(KW_MAX);
      jj_consume_token(KW_OPEN_PAREN);
      ma = Attribute();
      jj_consume_token(KW_CLOSED_PAREN);
      {if (true) return new MAggregate(MAggregate.AggOp.Max, ma);}
      break;
    case KW_AVG:
      jj_consume_token(KW_AVG);
      jj_consume_token(KW_OPEN_PAREN);
      ma = Attribute();
      jj_consume_token(KW_CLOSED_PAREN);
      {if (true) return new MAggregate(MAggregate.AggOp.Average, ma);}
      break;
    case KW_COUNT:
      jj_consume_token(KW_COUNT);
      jj_consume_token(KW_OPEN_PAREN);
      ma = Attribute();
      jj_consume_token(KW_CLOSED_PAREN);
      {if (true) return new MAggregate(MAggregate.AggOp.Count, ma);}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * And attibute. A single quoted String, or KEY, or VALUE or STAR (for doing count(*)).
 */
  final public MAttribute Attribute() throws ParseException {
  StringAndToken s;
  String t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_KEY:
      jj_consume_token(KW_KEY);
    {if (true) return MAttribute.KEY;}
      break;
    case KW_VALUE:
      jj_consume_token(KW_VALUE);
    {if (true) return MAttribute.VALUE;}
      break;
    case KW_STAR:
      jj_consume_token(KW_STAR);
    {if (true) return MAttribute.STAR;}
      break;
    case KW_ALL:
      jj_consume_token(KW_ALL);
    {if (true) return MAttribute.STAR;}
      break;
    case STRING:
      t = UnQuotedString();
    {if (true) return new MAttribute(t);}
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Single quoted string. Uses a support class to handle escapes and such. Regexp to
 * tokenize. 
 */
  final public StringAndToken SingleQuotedString() throws ParseException {
  Token t;
    t = jj_consume_token(QUOTEDSTR);
    {if (true) return new StringAndToken(t, ParserSupport.processQuotedString(t, t.image));}
    throw new Error("Missing return statement in function");
  }

/**
 * Unquoted string.
 */
  final public String UnQuotedString() throws ParseException {
  Token t;
    t = jj_consume_token(STRING);
    {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public EhcacheSearchParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[29];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x40000,0x0,0x0,0x0,0x8,0x0,0x0,0x8,0x0,0x0,0x30016,0x4000000,0x2000000,0x1000000,0x7000000,0x7000000,0xb0016,0x10,0x1f0ff00,0x40,0x80,0x8,0xff00,0x10,0x8,0xf8030006,0xf8000000,0x30006,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x180001,0x0,0x240000,0x240000,0x4,0x0,0x3c000,0x3c000,0x0,0x3c000,0x3c000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x1000000,0xc037f8,0x0,0x0,0x0,0x0,0x0,0xc037f8,0x0,0x1000000,0x0,0x1000000,};
   }

  /** Constructor with InputStream. */
  public EhcacheSearchParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public EhcacheSearchParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new EhcacheSearchParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public EhcacheSearchParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new EhcacheSearchParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public EhcacheSearchParser(EhcacheSearchParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(EhcacheSearchParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[62];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 29; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 62; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
