/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.test.selenium.browser.internal;

import com.google.common.base.Function;
import com.liferay.faces.test.selenium.browser.BrowserDriver;
import com.liferay.faces.test.selenium.browser.TestUtil;
import com.liferay.faces.test.selenium.browser.internal.ExpectedConditionsUtil;
import com.liferay.faces.test.selenium.browser.internal.HtmlUnitDriverLiferayFacesImpl;
import com.liferay.faces.test.selenium.expectedconditions.ElementEnabled;
import com.liferay.faces.test.selenium.util.ClosableUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserDriverImpl
implements BrowserDriver {
    private static final Logger logger = LoggerFactory.getLogger(BrowserDriverImpl.class);
    private static final String JAVA_IO_TMPDIR;
    private boolean browserHeadless;
    private boolean browserSimulatingMobile;
    private WebDriver webDriver;
    private WebDriverWait webDriverWait;
    private Integer windowHeight;

    public BrowserDriverImpl(WebDriver webDriver, boolean browserHeadless, boolean browserSimulatingMobile) {
        this.webDriver = webDriver;
        this.browserHeadless = browserHeadless;
        this.browserSimulatingMobile = browserSimulatingMobile;
        int browserWaitTimeOut = TestUtil.getBrowserDriverWaitTimeOut();
        this.webDriverWait = new WebDriverWait(webDriver, (long)browserWaitTimeOut);
    }

    @Override
    public void acceptAlert() {
        WebDriver webDriver = this.getWebDriver();
        webDriver.switchTo().alert().accept();
    }

    @Override
    public void captureCurrentBrowserState() {
        String outputDirectoryPath = TestUtil.getSystemPropertyOrDefault("integration.captured.browser.state.output.directory", JAVA_IO_TMPDIR + "captured-browser-state");
        this.captureCurrentBrowserState(outputDirectoryPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void captureCurrentBrowserState(String outputDirectoryPath, String fileNamePrefix) {
        block10: {
            File file = new File(outputDirectoryPath);
            file.mkdirs();
            StringBuilder buf = new StringBuilder();
            buf.append(outputDirectoryPath);
            buf.append("/");
            if (fileNamePrefix != null) {
                buf.append(fileNamePrefix);
                buf.append("_");
            }
            buf.append(this.getBrowserName());
            buf.append("_");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS", Locale.ENGLISH);
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            String dateString = simpleDateFormat.format(new Date());
            buf.append(dateString);
            String fileName = buf.toString();
            String htmlFileName = fileName + ".html";
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(htmlFileName, "UTF-8");
                String currentPageState = this.getCurrentDocumentMarkup();
                printWriter.write(currentPageState);
            }
            catch (Exception e) {
                try {
                    logger.error("Unable to write page source to {} due to the following exception:\n", (Object)htmlFileName);
                    logger.error("", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ClosableUtil.close(printWriter);
                    throw throwable;
                }
                ClosableUtil.close(printWriter);
            }
            ClosableUtil.close(printWriter);
            String currentUrl = this.getCurrentWindowUrl();
            logger.info("The html of url=\"{}\" has been written to {}", (Object)currentUrl, (Object)htmlFileName);
            WebDriver webDriver = this.getWebDriver();
            if (!(webDriver instanceof TakesScreenshot)) break block10;
            TakesScreenshot takesScreenshot = (TakesScreenshot)webDriver;
            byte[] screenshotBytes = (byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES);
            String screenshotFileName = fileName + ".png";
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(screenshotFileName);
                fileOutputStream.write(screenshotBytes);
            }
            catch (Exception e) {
                try {
                    logger.error("Unable to write page source to {} due to the following exception:\n", (Object)screenshotFileName);
                    logger.error("", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ClosableUtil.close(fileOutputStream);
                    throw throwable;
                }
                ClosableUtil.close(fileOutputStream);
            }
            ClosableUtil.close(fileOutputStream);
            logger.info("A screenshot of url=\"{}\" has been saved to {}", (Object)currentUrl, (Object)screenshotFileName);
        }
    }

    @Override
    public void centerElementInCurrentWindow(String elementXpath) {
        this.executeScriptInCurrentWindow("window.scrollTo(0, (arguments[0].getBoundingClientRect().top + window.pageYOffset) - (window.innerHeight / 2));", this.findElementByXpath(elementXpath));
    }

    @Override
    public void clearBrowserCookies() {
        WebDriver webDriver = this.getWebDriver();
        webDriver.manage().deleteAllCookies();
    }

    @Override
    public void clearElement(String elementXpath) {
        this.centerElementInCurrentWindow(elementXpath);
        WebElement element = this.findElementByXpath(elementXpath);
        String value = element.getAttribute("value");
        if (value != null && !value.equals("")) {
            CharSequence[] clearKeys = new CharSequence[value.length()];
            for (int i = 0; i < value.length(); ++i) {
                clearKeys[i] = Keys.BACK_SPACE;
            }
            this.sendKeysToElement(elementXpath, new CharSequence[]{Keys.END});
            this.sendKeysToElement(elementXpath, clearKeys);
        }
    }

    @Override
    public void clickElement(String elementXpath) {
        this.centerElementInCurrentWindow(elementXpath);
        this.findElementByXpath(elementXpath).click();
    }

    @Override
    public void clickElementAndWaitForRerender(String elementXpath) {
        this.performAndWaitForRerender(this.createClickElementAction(elementXpath), elementXpath);
    }

    @Override
    public void closeCurrentWindow() {
        WebDriver webDriver = this.getWebDriver();
        webDriver.close();
    }

    @Override
    public Actions createActions() {
        WebDriver webDriver = this.getWebDriver();
        return new Actions(webDriver);
    }

    @Override
    public Actions createActions(String elementXpath) {
        if (this.windowHeight == null) {
            Long windowHeightLong = (Long)this.executeScriptInCurrentWindow("return document.documentElement.clientHeight || window.innerHeight;", new Object[0]);
            this.windowHeight = windowHeightLong.intValue();
        }
        WebElement webElement = this.findElementByXpath(elementXpath);
        Dimension elementSize = webElement.getSize();
        int elementHeight = elementSize.getHeight();
        Actions actions = this.createActions();
        return actions.moveToElement(webElement, 0, -(this.windowHeight / 2) + elementHeight / 2);
    }

    @Override
    public Action createClickElementAction(String elementXpath) {
        Actions actions = this.createActions(elementXpath);
        WebElement webElement = this.findElementByXpath(elementXpath);
        actions = actions.click(webElement);
        return actions.build();
    }

    @Override
    public void dismissAlert() {
        WebDriver webDriver = this.getWebDriver();
        webDriver.switchTo().alert().dismiss();
    }

    @Override
    public Object executeScriptInCurrentWindow(String script, Object ... args) {
        WebDriver webDriver = this.getWebDriver();
        if (webDriver instanceof JavascriptExecutor) {
            JavascriptExecutor javaScriptExecutor = (JavascriptExecutor)webDriver;
            return javaScriptExecutor.executeScript(script, args);
        }
        throw new UnsupportedOperationException("Executing JavaScript is not supported by: " + this.getBrowserName());
    }

    @Override
    public WebElement findElementByXpath(String elementXpath) {
        WebDriver webDriver = this.getWebDriver();
        return webDriver.findElement(By.xpath((String)elementXpath));
    }

    @Override
    public List<WebElement> findElementsByXpath(String elementXpath) {
        WebDriver webDriver = this.getWebDriver();
        return webDriver.findElements(By.xpath((String)elementXpath));
    }

    @Override
    public Set<Cookie> getBrowserCookies() {
        WebDriver webDriver = this.getWebDriver();
        return webDriver.manage().getCookies();
    }

    @Override
    public String getBrowserName() {
        WebDriver webDriver = this.getWebDriver();
        if (webDriver instanceof RemoteWebDriver) {
            RemoteWebDriver remoteWebDriver = (RemoteWebDriver)webDriver;
            return remoteWebDriver.getCapabilities().getBrowserName();
        }
        throw new UnsupportedOperationException("getBrowserName() not supported by this browser.");
    }

    @Override
    public String getCurrentDocumentMarkup() {
        WebElement documentElement = this.findElementByXpath("/html");
        String outerHTMLAttrName = "outerHTML";
        String browserName = this.getBrowserName();
        if ("htmlunit".equals(browserName)) {
            outerHTMLAttrName = "innerHTML";
        }
        return documentElement.getAttribute(outerHTMLAttrName);
    }

    @Override
    public String getCurrentWindowId() {
        WebDriver webDriver = this.getWebDriver();
        return webDriver.getWindowHandle();
    }

    @Override
    public String getCurrentWindowUrl() {
        WebDriver webDriver = this.getWebDriver();
        return webDriver.getCurrentUrl();
    }

    @Override
    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    @Override
    public Set<String> getWindowIds() {
        WebDriver webDriver = this.getWebDriver();
        return webDriver.getWindowHandles();
    }

    @Override
    public boolean isBrowserHeadless() {
        return this.browserHeadless;
    }

    @Override
    public boolean isBrowserSimulatingMobile() {
        return this.browserSimulatingMobile;
    }

    @Override
    public void loadCurrentWindowImages() {
        String browserName = this.getBrowserName();
        if ("htmlunit".equals(browserName)) {
            WebDriver webDriver = this.getWebDriver();
            HtmlUnitDriverLiferayFacesImpl htmlUnitDriverLiferayFacesImpl = (HtmlUnitDriverLiferayFacesImpl)webDriver;
            htmlUnitDriverLiferayFacesImpl.loadCurrentWindowImages();
        } else {
            logger.warn("Images are automatically loaded by {}", (Object)browserName);
        }
    }

    @Override
    public void navigateWindowTo(String url) {
        WebDriver webDriver = this.getWebDriver();
        webDriver.get(url);
    }

    @Override
    public void performAndWaitForRerender(Action action, String rerenderXpath) {
        WebElement rerenderElement = this.findElementByXpath(rerenderXpath);
        action.perform();
        logger.info("Waiting for element {} to be stale.", (Object)rerenderXpath);
        this.waitFor(ExpectedConditions.stalenessOf((WebElement)rerenderElement));
        logger.info("Element {} is stale.", (Object)rerenderXpath);
        this.waitForElementDisplayed(rerenderXpath);
    }

    @Override
    public void quit() {
        WebDriver webDriver = this.getWebDriver();
        webDriver.quit();
    }

    @Override
    public void sendKeysToElement(String elementXpath, CharSequence ... keys) {
        this.centerElementInCurrentWindow(elementXpath);
        this.findElementByXpath(elementXpath).sendKeys(keys);
    }

    @Override
    public void setPageLoadTimeout(int waitTimeOutInSeconds) {
        WebDriver webDriver = this.getWebDriver();
        webDriver.manage().timeouts().pageLoadTimeout((long)waitTimeOutInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void setWaitTimeOut(int waitTimeOutInSeconds) {
        WebDriver webDriver = this.getWebDriver();
        this.webDriverWait = new WebDriverWait(webDriver, (long)waitTimeOutInSeconds);
    }

    @Override
    public void switchToFrame(String iframeXpath) {
        WebElement webElement = this.findElementByXpath(iframeXpath);
        WebDriver webDriver = this.getWebDriver();
        webDriver.switchTo().frame(webElement);
    }

    @Override
    public void switchToWindow(String windowId) {
        WebDriver webDriver = this.getWebDriver();
        webDriver.switchTo().window(windowId);
    }

    @Override
    public void waitFor(ExpectedCondition expectedCondition) {
        this.webDriverWait.until((Function)expectedCondition);
    }

    @Override
    public void waitForElementDisplayed(String elementXpath) {
        logger.info("Waiting for element {} to be displayed.", (Object)elementXpath);
        this.waitFor(ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)elementXpath)));
        logger.info("Element {} is displayed.", (Object)elementXpath);
    }

    @Override
    public void waitForElementEnabled(String elementXpath) {
        this.waitForElementEnabled(elementXpath, true);
    }

    @Override
    public void waitForElementEnabled(String elementXpath, boolean elementMustBeDisplayed) {
        logger.info("Waiting for element {} to be enabled.", (Object)elementXpath);
        By byXpath = By.xpath((String)elementXpath);
        ExpectedCondition<?> expectedCondition = ExpectedConditionsUtil.ifNecessaryExpectElementDisplayed(new ElementEnabled(elementXpath), elementMustBeDisplayed, byXpath);
        this.waitFor(expectedCondition);
        logger.info("Element {} is enabled.", (Object)elementXpath);
    }

    @Override
    public void waitForElementNotDisplayed(String elementXpath) {
        logger.info("Waiting for element {} not to be displayed.", (Object)elementXpath);
        this.waitFor(ExpectedConditions.invisibilityOfElementLocated((By)By.xpath((String)elementXpath)));
        logger.info("Element {} is not displayed.", (Object)elementXpath);
    }

    @Override
    public void waitForTextPresentInElement(String text, String elementXpath) {
        this.waitForTextPresentInElement(text, elementXpath, true);
    }

    @Override
    public void waitForTextPresentInElement(String text, String elementXpath, boolean elementMustBeDisplayed) {
        logger.info("Waiting for text \"{}\" to be present in element {}.", (Object)text, (Object)elementXpath);
        By byXpath = By.xpath((String)elementXpath);
        ExpectedCondition<?> expectedCondition = ExpectedConditions.textToBePresentInElementLocated((By)byXpath, (String)text);
        expectedCondition = ExpectedConditionsUtil.ifNecessaryExpectElementDisplayed(expectedCondition, elementMustBeDisplayed, byXpath);
        this.waitFor(expectedCondition);
        logger.info("Text \"{}\" is present in Element {}.", (Object)text, (Object)elementXpath);
    }

    static {
        String javaIOTmpdir = System.getProperty("java.io.tmpdir");
        if (!javaIOTmpdir.endsWith(File.separator)) {
            javaIOTmpdir = javaIOTmpdir + File.separator;
        }
        JAVA_IO_TMPDIR = javaIOTmpdir;
    }
}

