/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.xml;

import com.liferay.faces.util.xml.internal.SAXParserImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.annotation.versioning.ProviderType;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

@ProviderType
public class ConcurrentSAXParserFactory
extends SAXParserFactory {
    private Map<String, Boolean> featureMap = new ConcurrentHashMap<String, Boolean>();

    protected ConcurrentSAXParserFactory() {
    }

    public static SAXParserFactory newInstance() {
        return new ConcurrentSAXParserFactory();
    }

    @Override
    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        Boolean feature = this.featureMap.get(name);
        if (feature == null) {
            feature = Boolean.FALSE;
        }
        return feature;
    }

    @Override
    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        return new SAXParserImpl(this.isNamespaceAware(), this.isValidating(), this.featureMap);
    }

    @Override
    public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.featureMap.put(name, value);
    }
}

