/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.product.internal;

import com.liferay.faces.util.internal.CloseableUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class PackageManifest {
    private static final Logger logger = LoggerFactory.getLogger(PackageManifest.class);
    private static final String MANIFEST_MF_PATH = "META-INF/MANIFEST.MF";
    private String implementationVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageManifest(Class<?> clazz, String expectedImplementationTitle) {
        InputStream inputStream = null;
        try {
            Enumeration<URL> manifestURLs = clazz.getClassLoader().getResources(MANIFEST_MF_PATH);
            boolean found = false;
            while (manifestURLs.hasMoreElements() && !found) {
                URL manifestURL = manifestURLs.nextElement();
                inputStream = manifestURL.openStream();
                Manifest manifest = new Manifest(inputStream);
                Attributes mainAttributes = manifest.getMainAttributes();
                if (expectedImplementationTitle.equals(mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE))) {
                    this.implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    found = true;
                }
                inputStream.close();
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
        finally {
            CloseableUtil.close(inputStream);
        }
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }
}

