/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.mojarra.spi.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.FacesBundleUtil;
import com.liferay.faces.util.osgi.internal.FacesBundlesHandlerBase;
import com.sun.faces.config.FacesInitializer;
import com.sun.faces.spi.AnnotationProvider;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.servlet.ServletContext;
import javax.servlet.annotation.HandlesTypes;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class AnnotationProviderOSGiImpl
extends AnnotationProvider {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationProviderOSGiImpl.class);
    private static final Set<Class<?>> ANNOTATIONS_HANDLED_BY_MOJARRA;
    private static final String WEB_INF_CLASSES_PATH = "WEB-INF/classes/";

    public AnnotationProviderOSGiImpl() {
    }

    public AnnotationProviderOSGiImpl(ServletContext servletContext, AnnotationProvider annotationProvider) {
        super(servletContext);
        this.wrappedAnnotationProvider = annotationProvider;
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(Set<URI> set) {
        Map annotatedClasses;
        if (FacesBundleUtil.isCurrentWarThinWab()) {
            FacesBundlesHandlerAnnotationProviderOSGiImpl facesBundlesHandler = new FacesBundlesHandlerAnnotationProviderOSGiImpl();
            annotatedClasses = Collections.unmodifiableMap((Map)facesBundlesHandler.handleFacesBundles(this.sc, true));
        } else {
            annotatedClasses = this.wrappedAnnotationProvider.getAnnotatedClasses(set);
        }
        return annotatedClasses;
    }

    static {
        HashSet<Class> annotationsHandledByMojarra = new HashSet<Class>();
        try {
            Class<?> annotationScanningServletContainerInitializerClass = Class.forName(FacesInitializer.class.getName());
            HandlesTypes handledTypes = annotationScanningServletContainerInitializerClass.getAnnotation(HandlesTypes.class);
            Class[] annotationsHandledByMojarraArray = handledTypes.value();
            annotationsHandledByMojarra.addAll(Arrays.asList(annotationsHandledByMojarraArray));
            annotationsHandledByMojarra.addAll(Arrays.asList(FacesComponent.class, FacesConverter.class, FacesRenderer.class, FacesValidator.class, ManagedBean.class, NamedEvent.class, FacesBehavior.class, FacesBehaviorRenderer.class));
        }
        catch (ClassNotFoundException e) {
            logger.error(e);
        }
        catch (NoClassDefFoundError e) {
            logger.error(e);
        }
        ANNOTATIONS_HANDLED_BY_MOJARRA = !annotationsHandledByMojarra.isEmpty() ? Collections.unmodifiableSet(annotationsHandledByMojarra) : Collections.emptySet();
    }

    private static final class FacesBundlesHandlerAnnotationProviderOSGiImpl
    extends FacesBundlesHandlerBase<Map<Class<? extends Annotation>, Set<Class<?>>>> {
        private FacesBundlesHandlerAnnotationProviderOSGiImpl() {
        }

        private static boolean isClassInBundle(String classFilePath, Bundle bundle, boolean wab) {
            return bundle.getEntry(classFilePath) != null || wab && !classFilePath.startsWith(AnnotationProviderOSGiImpl.WEB_INF_CLASSES_PATH) && bundle.getEntry(AnnotationProviderOSGiImpl.WEB_INF_CLASSES_PATH + classFilePath) != null;
        }

        private static boolean isIgnored(String classFilePath) {
            return classFilePath.startsWith("com/liferay/taglib/") || classFilePath.startsWith("com/liferay/util/") || classFilePath.startsWith("com/sun/el/") || classFilePath.startsWith("com/sun/faces/") || classFilePath.startsWith("javax/annotation/") || classFilePath.startsWith("javax/el/") || classFilePath.startsWith("javax/enterprise/") || classFilePath.startsWith("javax/faces/") || classFilePath.startsWith("javax/inject/") || classFilePath.startsWith("javax/portlet/") || classFilePath.startsWith("javax/servlet/") || classFilePath.startsWith("javax/validation/") || classFilePath.startsWith("org/apache/") || classFilePath.startsWith("org/jboss/weld/") || classFilePath.startsWith("org/osgi/") || classFilePath.endsWith("package-info.class");
        }

        private static Class<?> loadBundleClass(Bundle bundle, String className) {
            Class clazz = null;
            try {
                clazz = bundle.loadClass(className);
            }
            catch (LinkageError linkageError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return clazz;
        }

        @Override
        protected Map<Class<? extends Annotation>, Set<Class<?>>> getInitialReturnValueObject() {
            HashMap annotatedClasses = new HashMap();
            for (Class<?> annotation : ANNOTATIONS_HANDLED_BY_MOJARRA) {
                annotatedClasses.put(annotation, new HashSet());
            }
            return annotatedClasses;
        }

        @Override
        protected void handleFacesBundle(Bundle bundle, FacesBundlesHandlerBase.ReturnValueReference<Map<Class<? extends Annotation>, Set<Class<?>>>> returnValueReference, boolean recurse) {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (bundleWiring != null) {
                int options = 2;
                if (recurse) {
                    options = 1;
                }
                Collection classFilePaths = bundleWiring.listResources("/", "*.class", options);
                boolean wab = FacesBundleUtil.isWab(bundle);
                for (String classFilePath : classFilePaths) {
                    Annotation[] classAnnotations;
                    if (!FacesBundlesHandlerAnnotationProviderOSGiImpl.isClassInBundle(classFilePath, bundle, wab) && FacesBundlesHandlerAnnotationProviderOSGiImpl.isIgnored(classFilePath)) continue;
                    String className = classFilePath.replaceAll("\\.class$", "").replace("/", ".");
                    Class<?> clazz = FacesBundlesHandlerAnnotationProviderOSGiImpl.loadBundleClass(bundle, className);
                    if (clazz == null) {
                        if (classFilePath.endsWith("FileEntryBridgeImpl.class")) continue;
                        logger.warn("Unable to load class for annotation scanning: {0}", classFilePath);
                        continue;
                    }
                    for (Annotation annotation : classAnnotations = clazz.getAnnotations()) {
                        Class<? extends Annotation> annotationType = annotation.annotationType();
                        if (!ANNOTATIONS_HANDLED_BY_MOJARRA.contains(annotationType)) continue;
                        returnValueReference.get().get(annotationType).add(clazz);
                    }
                }
            }
        }
    }
}

