/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.BeanManagerELResolver;
import com.liferay.faces.util.osgi.internal.BeanManagerExpressionFactory;
import java.util.Map;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.SystemEvent;

public class ApplicationOSGiCDIImpl
extends ApplicationWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationOSGiCDIImpl.class);
    private ExpressionFactory expressionFactory;
    private Application wrappedApplication;

    public ApplicationOSGiCDIImpl(Application wrappedApplication) {
        this.wrappedApplication = wrappedApplication;
        CDI currentCDI = CDI.current();
        if (currentCDI != null) {
            wrappedApplication.addELResolver((ELResolver)new BeanManagerELResolver());
            try {
                Class<?> listenerClass = Class.forName("org.jboss.weld.module.web.el.WeldELContextListener");
                wrappedApplication.addELContextListener((ELContextListener)listenerClass.newInstance());
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    public ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            this.expressionFactory = new BeanManagerExpressionFactory(this.wrappedApplication.getExpressionFactory());
        }
        return this.expressionFactory;
    }

    public Application getWrapped() {
        return this.wrappedApplication;
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Object source) {
        this.initBeanManagerApplicationScopedBean(facesContext.getExternalContext());
        super.publishEvent(facesContext, systemEventClass, source);
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Class<?> sourceBaseType, Object source) {
        this.initBeanManagerApplicationScopedBean(facesContext.getExternalContext());
        super.publishEvent(facesContext, systemEventClass, sourceBaseType, source);
    }

    private void initBeanManagerApplicationScopedBean(ExternalContext externalContext) {
        CDI current;
        Map applicationMap = externalContext.getApplicationMap();
        if (!applicationMap.containsKey("org.jboss.weld.environment.servlet.javax.enterprise.inject.spi.BeanManager") && (current = CDI.current()) != null) {
            try {
                BeanManager beanManager = current.getBeanManager();
                if (beanManager != null) {
                    applicationMap.put("org.jboss.weld.environment.servlet.javax.enterprise.inject.spi.BeanManager", beanManager);
                }
            }
            catch (IllegalStateException e) {
                logger.error(e);
            }
        }
    }
}

