/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.model;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.Paginated;
import com.liferay.faces.util.model.SortCriterion;
import com.liferay.faces.util.model.Sortable;
import java.util.Collection;
import java.util.List;
import javax.faces.model.DataModel;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class OnDemandDataModel<E>
extends DataModel<E>
implements Paginated,
Sortable {
    private static final Logger logger = LoggerFactory.getLogger(OnDemandDataModel.class);
    private int finishRowIndex = -1;
    private int rowCount = -1;
    private int rowIndex = -1;
    private int rowsPerPage;
    private List<SortCriterion> sortCriteria;
    private int startRowIndex = -1;
    private List<E> wrappedData;

    public abstract int countRows();

    public abstract Collection<E> findRows(int var1, int var2, List<SortCriterion> var3);

    public int getFinishRowIndex() {
        return this.finishRowIndex;
    }

    public int getRowCount() {
        if (this.rowCount == -1) {
            this.rowCount = this.countRows();
        }
        return this.rowCount;
    }

    public E getRowData() {
        if (this.getRowIndex() >= 0) {
            Object wrappedData;
            int adjustedRowIndex = this.getRowIndex() % this.getRowsPerPage();
            if (adjustedRowIndex >= (wrappedData = this.getWrappedData()).size()) {
                logger.error("adjustedRowIndex=[{0}] higher than wrappedData.size=[{1}]", adjustedRowIndex, wrappedData.size());
                return null;
            }
            return this.getWrappedData().get(adjustedRowIndex);
        }
        return null;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Override
    public List<SortCriterion> getSortCriteria() {
        return this.sortCriteria;
    }

    public int getStartRowIndex() {
        return this.startRowIndex;
    }

    public List<E> getWrappedData() {
        if (this.wrappedData == null) {
            int startRowIndex = this.rowIndex;
            int finishRowIndex = Math.min(this.rowIndex + this.getRowsPerPage() - 1, this.getRowCount() - 1);
            logger.debug("finding new startRowIndex=[{0}] finishRowIndex=[{1}]", startRowIndex, finishRowIndex);
            this.setWrappedData(this.findRows(startRowIndex, finishRowIndex, this.sortCriteria));
            this.setFinishRowIndex(finishRowIndex);
            this.setStartRowIndex(startRowIndex);
        }
        return this.wrappedData;
    }

    public boolean isRowAvailable() {
        int rowIndex = this.getRowIndex();
        return rowIndex >= 0 && rowIndex < this.getRowCount();
    }

    public void reset() {
        this.setRowCount(-1);
        this.setWrappedData(null);
        this.setStartRowIndex(-1);
        this.setFinishRowIndex(-1);
    }

    public void setFinishRowIndex(int finishRowIndex) {
        this.finishRowIndex = finishRowIndex;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex >= 0) {
            int startRowIndex = this.getStartRowIndex();
            int finishRowIndex = this.getFinishRowIndex();
            if (startRowIndex >= 0 && finishRowIndex >= 0) {
                int maxFinishRowIndex = startRowIndex + this.getRowsPerPage() - 1;
                if (rowIndex < startRowIndex || rowIndex > maxFinishRowIndex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Clearing cache since rowIndex=[{0}] is outside the range of cached rows.", rowIndex);
                    }
                    this.reset();
                }
            }
        }
        this.rowIndex = rowIndex;
    }

    @Override
    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    @Override
    public void setSortCriteria(List<SortCriterion> sortCriteria) {
        this.sortCriteria = sortCriteria;
        this.reset();
    }

    public void setStartRowIndex(int startRowIndex) {
        this.startRowIndex = startRowIndex;
    }

    public void setWrappedData(Object wrappedData) {
        this.wrappedData = wrappedData == null ? null : (List)wrappedData;
    }
}

