/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.logging.internal;

import com.liferay.faces.util.logging.internal.LoggerDefaultImpl;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerLog4J2Impl
extends LoggerDefaultImpl {
    private static final String CALLING_CLASS_FQCN = LoggerLog4J2Impl.class.getName();
    private Logger wrappedLogger;
    private Boolean traceSupported;

    public LoggerLog4J2Impl(String className) {
        try {
            StackTraceElement[] stackTraceElements;
            boolean webappContextStopping = false;
            for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
                if (!stackTraceElement.getClassName().equals("org.apache.catalina.core.StandardContext") || !stackTraceElement.getMethodName().equals("stop")) continue;
                webappContextStopping = true;
            }
            if (!webappContextStopping) {
                this.wrappedLogger = LogManager.getLogger((String)className);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnabled()) {
            try {
                this._logMessage(Level.DEBUG, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String message, Object ... arguments) {
        if (this.isDebugEnabled()) {
            try {
                String formattedMessage = this.formatMessage(message, arguments);
                Throwable throwable = this.getThrowable(arguments);
                this._logMessage(Level.DEBUG, formattedMessage, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(Throwable throwable) {
        if (this.isErrorEnabled()) {
            try {
                String message = throwable.getMessage();
                this._logMessage(Level.ERROR, message, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String message) {
        if (this.isErrorEnabled()) {
            try {
                this._logMessage(Level.ERROR, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String message, Object ... arguments) {
        if (this.isErrorEnabled()) {
            try {
                String formattedMessage = this.formatMessage(message, arguments);
                Throwable throwable = this.getThrowable(arguments);
                this._logMessage(Level.ERROR, formattedMessage, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String message) {
        if (this.isInfoEnabled()) {
            try {
                this._logMessage(Level.INFO, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String message, Object ... arguments) {
        if (this.isInfoEnabled()) {
            try {
                String formattedMessage = this.formatMessage(message, arguments);
                Throwable throwable = this.getThrowable(arguments);
                this._logMessage(Level.INFO, formattedMessage, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.wrappedLogger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.wrappedLogger.isEnabled(Level.ERROR);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.wrappedLogger.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.wrappedLogger.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.wrappedLogger.isEnabled(Level.WARN);
    }

    @Override
    public void trace(String message) {
        if (this.isTraceSupported()) {
            if (this.isTraceEnabled()) {
                try {
                    this._logMessage(Level.TRACE, message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.debug(message);
        }
    }

    @Override
    public void trace(String message, Object ... arguments) {
        if (this.isTraceSupported()) {
            if (this.isTraceEnabled()) {
                try {
                    String formattedMessage = this.formatMessage(message, arguments);
                    Throwable throwable = this.getThrowable(arguments);
                    this._logMessage(Level.TRACE, formattedMessage, throwable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.debug(message, arguments);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            try {
                this._logMessage(Level.WARN, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void warn(String message, Object ... arguments) {
        if (this.isWarnEnabled()) {
            try {
                String formattedMessage = this.formatMessage(message, arguments);
                Throwable throwable = this.getThrowable(arguments);
                this._logMessage(Level.WARN, formattedMessage, throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isTraceSupported() {
        if (this.traceSupported == null) {
            try {
                this.isTraceEnabled();
                this.traceSupported = Boolean.TRUE;
            }
            catch (NoSuchMethodError e) {
                this.traceSupported = Boolean.FALSE;
            }
        }
        return this.traceSupported;
    }

    private void _logMessage(Level level, String message) {
        this._logMessage(level, message, null);
    }

    private void _logMessage(Level level, String message, Throwable throwable) {
        if (this.wrappedLogger instanceof ExtendedLogger) {
            ExtendedLogger extendedLogger = (ExtendedLogger)this.wrappedLogger;
            extendedLogger.logMessage(CALLING_CLASS_FQCN, level, null, (Message)new SimpleMessage(message), throwable);
        } else {
            this.wrappedLogger.logMessage(level, MarkerManager.getMarker((String)"LFU"), CALLING_CLASS_FQCN, null, (Message)new SimpleMessage(message), throwable);
        }
    }
}

