/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.internal.FacesConfigDescriptor;
import com.liferay.faces.util.config.internal.Ordering;
import com.liferay.faces.util.config.internal.OrderingBeforeAndAfterException;
import com.liferay.faces.util.config.internal.OrderingCircularDependencyException;
import com.liferay.faces.util.config.internal.OrderingMaxAttemptsException;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OrderingUtil {
    private static final Logger logger = LoggerFactory.getLogger(OrderingUtil.class);
    private static final int MAX_ATTEMPTS = 1048;

    private OrderingUtil() {
        throw new AssertionError();
    }

    public static Map<String, FacesConfigDescriptor> getConfigMap(List<FacesConfigDescriptor> facesConfigDescriptors) {
        HashMap<String, FacesConfigDescriptor> configMap = new HashMap<String, FacesConfigDescriptor>();
        for (FacesConfigDescriptor facesConfigDescriptor : facesConfigDescriptors) {
            String name = facesConfigDescriptor.getName();
            configMap.put(name, facesConfigDescriptor);
        }
        return configMap;
    }

    public static List<FacesConfigDescriptor> getOrderedFacesConfigDescriptors(FacesConfigDescriptor mojarraConfigDescriptor, List<FacesConfigDescriptor> facesConfigDescriptors, FacesConfigDescriptor webInfFacesConfigDescriptor) throws Exception {
        if (facesConfigDescriptors.size() > 1) {
            facesConfigDescriptors = webInfFacesConfigDescriptor != null && webInfFacesConfigDescriptor.hasAbsoluteOrdering() ? OrderingUtil.getAbsoluteOrderedFacesConfigDescriptors(mojarraConfigDescriptor, facesConfigDescriptors, webInfFacesConfigDescriptor) : OrderingUtil.getRelativeOrderedFacesConfigDescriptors(mojarraConfigDescriptor, facesConfigDescriptors, webInfFacesConfigDescriptor);
        }
        return facesConfigDescriptors;
    }

    private static String[] appendAndSort(String[] ... groups) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (groups[0] != null && OrderingUtil.containsOthers(groups[0])) {
            map.put(Ordering.OTHERS, 1);
        }
        String[][] stringArray = groups;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] group;
            for (String name : group = stringArray[i]) {
                if (name.equals(Ordering.OTHERS)) continue;
                map.put(name, 1);
            }
        }
        Set keySet = map.keySet();
        Object[] orderedNames = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(orderedNames);
        return orderedNames;
    }

    private static void checkForBothBeforeAndAfter(FacesConfigDescriptor config) throws OrderingBeforeAndAfterException {
        String[] namesToCheck;
        String[] afterRoutes;
        String[] beforeRoutes;
        String configName = config.getName();
        Ordering configOrdering = config.getOrdering();
        EnumMap<Ordering.Path, String[]> orderingRoutes = configOrdering.getRoutes();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String name : beforeRoutes = orderingRoutes.get((Object)Ordering.Path.BEFORE)) {
            Integer value = (Integer)map.get(name);
            value = value == null ? Integer.valueOf(1) : Integer.valueOf(value + 1);
            map.put(name, value);
        }
        for (String name : afterRoutes = orderingRoutes.get((Object)Ordering.Path.AFTER)) {
            Integer value = (Integer)map.get(name);
            value = value == null ? Integer.valueOf(1) : Integer.valueOf(value + 1);
            map.put(name, value);
        }
        Set keySet = map.keySet();
        for (String name : namesToCheck = keySet.toArray(new String[keySet.size()])) {
            if ((Integer)map.get(name) <= 1) continue;
            throw new OrderingBeforeAndAfterException(configName, name);
        }
    }

    private static void checkForSpecExceptions(List<FacesConfigDescriptor> configs) throws OrderingBeforeAndAfterException, OrderingCircularDependencyException {
        for (FacesConfigDescriptor config : configs) {
            OrderingUtil.checkForBothBeforeAndAfter(config);
            for (Ordering.Path path : Ordering.Path.values()) {
                OrderingUtil.mapRoutes(config, path, configs);
            }
        }
    }

    private static boolean containsOthers(String[] route) {
        return Arrays.binarySearch(route, Ordering.OTHERS) >= 0;
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> descendingByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return ((Comparable)b.getValue()).compareTo(a.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    private static LinkedList<String> extractNamesList(FacesConfigDescriptor[] configs) {
        LinkedList<String> names = new LinkedList<String>();
        for (FacesConfigDescriptor config : configs) {
            names.add(config.getName());
        }
        return names;
    }

    private static List<FacesConfigDescriptor> getAbsoluteOrderedFacesConfigDescriptors(FacesConfigDescriptor mojarraConfigDescriptor, List<FacesConfigDescriptor> configList, FacesConfigDescriptor webInfFacesConfigDescriptor) {
        List<String> absoluteOrdering = webInfFacesConfigDescriptor.getAbsoluteOrdering();
        logger.debug("Ordering faces-config descriptors: absoluteOrdering=[{0}]", absoluteOrdering);
        ArrayList<FacesConfigDescriptor> orderedConfigList = new ArrayList<FacesConfigDescriptor>();
        if (mojarraConfigDescriptor != null) {
            orderedConfigList.add(mojarraConfigDescriptor);
        }
        configList = new ArrayList<FacesConfigDescriptor>(configList);
        for (String name : absoluteOrdering) {
            if (Ordering.OTHERS.equals(name)) continue;
            boolean found = false;
            Iterator<FacesConfigDescriptor> iterator = configList.iterator();
            while (iterator.hasNext()) {
                FacesConfigDescriptor config = iterator.next();
                if (!found && name.equals(config.getName())) {
                    found = true;
                    orderedConfigList.add(config);
                    iterator.remove();
                    continue;
                }
                if (!found || !name.equals(config.getName())) continue;
                logger.warn("name=[{0}] found more than once", name);
                break;
            }
            if (found) continue;
            logger.warn("name=[{0}] specified in absolute-ordering was not found", name);
        }
        int othersIndex = absoluteOrdering.indexOf(Ordering.OTHERS);
        if (othersIndex != -1) {
            for (FacesConfigDescriptor config : configList) {
                orderedConfigList.add(othersIndex, config);
            }
        }
        orderedConfigList.add(webInfFacesConfigDescriptor);
        return orderedConfigList;
    }

    private static List<FacesConfigDescriptor> getRelativeOrderedFacesConfigDescriptors(FacesConfigDescriptor mojarraConfigDescriptor, List<FacesConfigDescriptor> configList, FacesConfigDescriptor webInfFacesConfigDescriptor) throws OrderingBeforeAndAfterException, OrderingCircularDependencyException, OrderingMaxAttemptsException {
        String[] afterRoutes;
        String[] beforeRoutes;
        EnumMap<Ordering.Path, String[]> routes;
        Ordering ordering;
        String name;
        logger.debug("Ordering faces-config descriptors");
        if (logger.isTraceEnabled()) {
            for (FacesConfigDescriptor config : configList) {
                name = config.getName();
                ordering = config.getOrdering();
                if (ordering == null || (routes = ordering.getRoutes()) == null) continue;
                beforeRoutes = routes.get((Object)Ordering.Path.BEFORE);
                if (beforeRoutes.length != 0) {
                    logger.trace("before name=[{0}] b routes=[{1}] beforeOthers=[{2}]", name, Arrays.asList(beforeRoutes).toString(), ordering.isBeforeOthers());
                }
                if ((afterRoutes = routes.get((Object)Ordering.Path.AFTER)).length == 0) continue;
                logger.trace("before name=[{0}] a routes=[{1}] afterOthers=[{2}]", name, Arrays.asList(afterRoutes).toString(), ordering.isAfterOthers());
            }
        }
        OrderingUtil.checkForSpecExceptions(configList);
        if (logger.isTraceEnabled()) {
            for (FacesConfigDescriptor config : configList) {
                name = config.getName();
                ordering = config.getOrdering();
                if (ordering == null || (routes = ordering.getRoutes()) == null) continue;
                beforeRoutes = routes.get((Object)Ordering.Path.BEFORE);
                if (beforeRoutes.length != 0) {
                    logger.trace("after name=[{0}] b routes=[{1}] beforeOthers=[{2}]", name, Arrays.asList(beforeRoutes).toString(), ordering.isBeforeOthers());
                }
                if ((afterRoutes = routes.get((Object)Ordering.Path.AFTER)).length == 0) continue;
                logger.trace("after name=[{0}] b routes=[{1}] afterOthers=[{2}]", name, Arrays.asList(afterRoutes).toString(), ordering.isAfterOthers());
            }
        }
        configList = OrderingUtil.preSort(configList);
        int size = configList.size();
        FacesConfigDescriptor[] configs = configList.toArray(new FacesConfigDescriptor[size]);
        OrderingUtil.innerSort(configs);
        OrderingUtil.postSort(configs);
        ArrayList<FacesConfigDescriptor> orderedConfigList = new ArrayList<FacesConfigDescriptor>();
        if (mojarraConfigDescriptor != null) {
            orderedConfigList.add(mojarraConfigDescriptor);
        }
        orderedConfigList.addAll(Arrays.asList(configs));
        if (webInfFacesConfigDescriptor != null) {
            orderedConfigList.add(webInfFacesConfigDescriptor);
        }
        return orderedConfigList;
    }

    private static int innerSort(FacesConfigDescriptor[] configs) throws OrderingMaxAttemptsException {
        int attempts = 0;
        boolean attempting = true;
        while (attempting) {
            if (attempts > 1048) {
                throw new OrderingMaxAttemptsException(1048);
            }
            attempting = false;
            int last = configs.length - 1;
            for (int i = 0; i < configs.length; ++i) {
                int first = i;
                int second = first + 1;
                if (first == last) {
                    second = first;
                    first = 0;
                }
                if (!OrderingUtil.isDisordered(configs[first], configs[second])) continue;
                FacesConfigDescriptor temp = configs[first];
                configs[first] = configs[second];
                configs[second] = temp;
                attempting = true;
            }
            ++attempts;
        }
        logger.trace("attempt#{0} of {1}", attempts, 1048);
        return attempts;
    }

    private static boolean isDisordered(FacesConfigDescriptor config1, FacesConfigDescriptor config2) {
        String config1Name = config1.getName();
        String config2Name = config2.getName();
        Ordering config1Ordering = config1.getOrdering();
        Ordering config2Ordering = config2.getOrdering();
        if (config1Ordering.isOrdered() && !config2Ordering.isOrdered() && config1Ordering.getRoutes().get((Object)Ordering.Path.AFTER).length != 0 && !config1Ordering.isBeforeOthers()) {
            return true;
        }
        if (config2Ordering.isBefore(config1Name) || config1Ordering.isAfter(config2Name)) {
            return true;
        }
        if (!(!config1Ordering.isAfterOthers() || config1Ordering.isBefore(config2Name) || config1Ordering.isAfterOthers() && config2Ordering.isAfterOthers())) {
            return true;
        }
        return config2Ordering.isBeforeOthers() && !config2Ordering.isAfter(config1Name) && (!config1Ordering.isBeforeOthers() || !config2Ordering.isBeforeOthers());
    }

    private static void mapRoutes(FacesConfigDescriptor config, Ordering.Path path, List<FacesConfigDescriptor> facesConfigs) throws OrderingCircularDependencyException {
        String[] routePathNames;
        String configName = config.getName();
        Ordering configOrdering = config.getOrdering();
        EnumMap<Ordering.Path, String[]> configOrderingRoutes = configOrdering.getRoutes();
        for (String routePathName : routePathNames = configOrderingRoutes.get((Object)path)) {
            if (routePathName.equals(Ordering.OTHERS)) continue;
            for (FacesConfigDescriptor otherConfig : facesConfigs) {
                EnumMap<Ordering.Path, String[]> routes;
                String otherConfigName = otherConfig.getName();
                if (!routePathName.equals(otherConfigName)) continue;
                Ordering otherConfigOrdering = otherConfig.getOrdering();
                EnumMap<Ordering.Path, String[]> otherConfigOrderingRoutes = otherConfigOrdering.getRoutes();
                Object[] otherRoutePathNames = otherConfigOrderingRoutes.get((Object)path);
                if (Arrays.binarySearch(otherRoutePathNames, configName) >= 0) {
                    throw new OrderingCircularDependencyException(path, facesConfigs);
                }
                Ordering.Path oppositePath = path == Ordering.Path.BEFORE ? Ordering.Path.AFTER : Ordering.Path.BEFORE;
                if (Arrays.binarySearch(otherConfigOrderingRoutes.get((Object)oppositePath), configName) < 0) {
                    routes = new EnumMap<Ordering.Path, String[]>(Ordering.Path.class);
                    routes.put(path, (String[])otherRoutePathNames);
                    routes.put(oppositePath, OrderingUtil.appendAndSort(otherConfigOrderingRoutes.get((Object)oppositePath), {configName}));
                    otherConfigOrdering.setRoutes(routes);
                }
                if (otherRoutePathNames.length <= 0) continue;
                routes = new EnumMap(Ordering.Path.class);
                routes.put(path, OrderingUtil.appendAndSort(new String[][]{routePathNames, otherRoutePathNames}));
                routes.put(oppositePath, configOrderingRoutes.get((Object)oppositePath));
                configOrdering.setRoutes(routes);
            }
        }
    }

    private static void postSort(FacesConfigDescriptor[] configs) {
        int i = 0;
        while (i < configs.length) {
            LinkedList<String> names = OrderingUtil.extractNamesList(configs);
            boolean done = true;
            block1: for (int j = 0; j < configs.length; ++j) {
                int k = 0;
                for (String configName : names) {
                    if (configs[j].getName().equals(configName)) continue block1;
                    if (configs[j].getOrdering().isBefore(configName)) {
                        FacesConfigDescriptor temp = null;
                        for (int m = 0; m < configs.length; ++m) {
                            if (m == k) {
                                temp = configs[m];
                            }
                            if (temp != null && m != j) {
                                configs[m] = configs[m + 1];
                            }
                            if (m != j) continue;
                            configs[m] = temp;
                            done = false;
                            break;
                        }
                        if (!done) continue block1;
                    }
                    ++k;
                }
            }
            if (!done) continue;
            break;
        }
    }

    private static List<FacesConfigDescriptor> preSort(List<FacesConfigDescriptor> configs) {
        ArrayList<FacesConfigDescriptor> newConfigList = new ArrayList<FacesConfigDescriptor>();
        LinkedList<FacesConfigDescriptor> anonAndUnordered = new LinkedList<FacesConfigDescriptor>();
        Map<String, Integer> namedMap = new LinkedHashMap();
        for (FacesConfigDescriptor config : configs) {
            Ordering configOrdering = config.getOrdering();
            EnumMap<Ordering.Path, String[]> configOrderingRoutes = configOrdering.getRoutes();
            String[] beforePathNames = configOrderingRoutes.get((Object)Ordering.Path.BEFORE);
            String[] afterPathNames = configOrderingRoutes.get((Object)Ordering.Path.AFTER);
            String configName = config.getName();
            if (!(configName != null && configName.length() != 0 || configOrdering.isOrdered())) {
                anonAndUnordered.add(config);
                continue;
            }
            int totalPathNames = beforePathNames.length + afterPathNames.length;
            namedMap.put(configName, totalPathNames);
        }
        namedMap = OrderingUtil.descendingByValue(namedMap);
        Map<String, FacesConfigDescriptor> configMap = OrderingUtil.getConfigMap(configs);
        for (Map.Entry entry : namedMap.entrySet()) {
            String key = (String)entry.getKey();
            newConfigList.add(configMap.get(key));
        }
        for (FacesConfigDescriptor config : anonAndUnordered) {
            newConfigList.add(config);
        }
        return newConfigList;
    }
}

